/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Code generated by "stringer -type=DBType"; DO NOT EDIT.

package types

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[DBTypeUnknown-1]
	_ = x[DBTypeMySQL-2]
	_ = x[DBTypePostgreSQL-3]
	_ = x[DBTypeSQLServer-4]
	_ = x[DBTypeOracle-5]
}

const _DBType_name = "DBTypeUnknownDBTypeMySQLDBTypePostgreSQLDBTypeSQLServerDBTypeOracle"

var _DBType_index = [...]uint8{0, 13, 24, 40, 55, 67}

func (i DBType) String() string {
	i -= 1
	if i < 0 || i >= DBType(len(_DBType_index)-1) {
		return "DBType(" + strconv.FormatInt(int64(i+1), 10) + ")"
	}
	return _DBType_name[_DBType_index[i]:_DBType_index[i+1]]
}
