/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.io;

import org.apache.james.mime4j.io.BufferedLineReaderInputStream;
import org.apache.james.mime4j.io.InputStreams;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;
import org.junit.Test;

public class BufferedLineReaderInputStreamBufferTest {
    private static BufferedLineReaderInputStream create(String s) {
        return new BufferedLineReaderInputStream(InputStreams.createAscii((CharSequence)s), 4096);
    }

    private static BufferedLineReaderInputStream create(byte[] b) {
        return new BufferedLineReaderInputStream(InputStreams.create((byte[])b), 4096);
    }

    @Test
    public void testInvalidInput() throws Exception {
        String text = "blah blah yada yada";
        String pattern = "blah";
        byte[] b2 = ContentUtil.toAsciiByteArray((String)pattern);
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(text);
        inbuffer.fillBuffer();
        Assert.assertEquals((long)98L, (long)inbuffer.read());
        Assert.assertEquals((long)108L, (long)inbuffer.read());
        try {
            inbuffer.byteAt(1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            inbuffer.byteAt(20);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            inbuffer.indexOf(b2, -1, 3);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            inbuffer.indexOf(b2, 1, 3);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            inbuffer.indexOf(b2, 2, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            inbuffer.indexOf(b2, 2, 18);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)5L, (long)inbuffer.indexOf(b2, 2, 17));
        try {
            inbuffer.indexOf((byte)32, -1, 3);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            inbuffer.indexOf((byte)32, 1, 3);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            inbuffer.indexOf((byte)32, 2, -1);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            inbuffer.indexOf((byte)32, 2, 18);
            Assert.fail((String)"IndexOutOfBoundsException should have been thrown");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)10L, (long)inbuffer.indexOf((byte)121, 2, 17));
        inbuffer.close();
    }

    @Test
    public void testBasicOperations() throws Exception {
        String text = "bla bla yada yada haha haha";
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(text);
        inbuffer.fillBuffer();
        Assert.assertEquals((long)0L, (long)inbuffer.pos());
        Assert.assertEquals((long)27L, (long)inbuffer.limit());
        Assert.assertEquals((long)27L, (long)inbuffer.length());
        inbuffer.read();
        inbuffer.read();
        Assert.assertEquals((long)2L, (long)inbuffer.pos());
        Assert.assertEquals((long)27L, (long)inbuffer.limit());
        Assert.assertEquals((long)25L, (long)inbuffer.length());
        byte[] tmp1 = new byte[3];
        Assert.assertEquals((long)3L, (long)inbuffer.read(tmp1));
        Assert.assertEquals((long)5L, (long)inbuffer.pos());
        Assert.assertEquals((long)27L, (long)inbuffer.limit());
        Assert.assertEquals((long)22L, (long)inbuffer.length());
        byte[] tmp2 = new byte[22];
        Assert.assertEquals((long)22L, (long)inbuffer.read(tmp2));
        Assert.assertEquals((long)27L, (long)inbuffer.pos());
        Assert.assertEquals((long)27L, (long)inbuffer.limit());
        Assert.assertEquals((long)0L, (long)inbuffer.length());
        Assert.assertEquals((long)-1L, (long)inbuffer.read(tmp1));
        Assert.assertEquals((long)-1L, (long)inbuffer.read(tmp1));
        Assert.assertEquals((long)-1L, (long)inbuffer.read());
        Assert.assertEquals((long)-1L, (long)inbuffer.read());
        inbuffer.close();
    }

    @Test
    public void testPatternMatching1() throws Exception {
        String text = "blabla d is the word";
        String pattern = "d";
        byte[] b2 = ContentUtil.toAsciiByteArray((String)pattern);
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(text);
        inbuffer.fillBuffer();
        int i = inbuffer.indexOf(b2);
        Assert.assertEquals((long)7L, (long)i);
        inbuffer.close();
    }

    @Test
    public void testPatternMatching2() throws Exception {
        String text = "disddisdissdsidsidsiid";
        String pattern = "siid";
        byte[] b2 = ContentUtil.toAsciiByteArray((String)pattern);
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(text);
        inbuffer.fillBuffer();
        int i = inbuffer.indexOf(b2);
        Assert.assertEquals((long)18L, (long)i);
        inbuffer.close();
    }

    @Test
    public void testPatternMatching3() throws Exception {
        String text = "bla bla yada yada haha haha";
        String pattern = "blah";
        byte[] b2 = ContentUtil.toAsciiByteArray((String)pattern);
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(text);
        inbuffer.fillBuffer();
        int i = inbuffer.indexOf(b2);
        Assert.assertEquals((long)-1L, (long)i);
        inbuffer.close();
    }

    @Test
    public void testPatternMatching4() throws Exception {
        String text = "bla bla yada yada haha haha";
        String pattern = "bla";
        byte[] b2 = ContentUtil.toAsciiByteArray((String)pattern);
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(text);
        inbuffer.fillBuffer();
        int i = inbuffer.indexOf(b2);
        Assert.assertEquals((long)0L, (long)i);
        inbuffer.close();
    }

    @Test
    public void testPatternOutOfBound() throws Exception {
        String text = "bla bla yada yada haha haha";
        String pattern1 = "bla bla";
        byte[] b2 = ContentUtil.toAsciiByteArray((String)pattern1);
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(text);
        inbuffer.fillBuffer();
        byte[] tmp = new byte[3];
        inbuffer.read(tmp);
        int i = inbuffer.indexOf(b2, inbuffer.pos(), inbuffer.length());
        Assert.assertEquals((long)-1L, (long)i);
        i = inbuffer.indexOf(b2, inbuffer.pos(), inbuffer.length() - 1);
        Assert.assertEquals((long)-1L, (long)i);
        inbuffer.close();
    }

    @Test
    public void testCharOutOfBound() throws Exception {
        String text = "zzz blah blah blah ggg";
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(text);
        inbuffer.fillBuffer();
        byte[] tmp = new byte[3];
        inbuffer.read(tmp);
        int i = inbuffer.indexOf((byte)122, inbuffer.pos(), inbuffer.length());
        Assert.assertEquals((long)-1L, (long)i);
        i = inbuffer.indexOf((byte)103, inbuffer.pos(), inbuffer.length() - 3);
        Assert.assertEquals((long)-1L, (long)i);
        inbuffer.close();
    }

    @Test
    public void test0xFFInBinaryStream() throws Exception {
        byte[] b1 = new byte[]{1, 2, 3, -1, 10, 1, 2, 3};
        byte[] b2 = new byte[]{10};
        BufferedLineReaderInputStream inbuffer = BufferedLineReaderInputStreamBufferTest.create(b1);
        inbuffer.fillBuffer();
        int i = inbuffer.indexOf(b2);
        Assert.assertEquals((long)4L, (long)i);
        inbuffer.close();
    }
}

