/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.james.core.MailAddress;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.ReceivedDataLineFilter;

public class ReceivedHeaderGenerator {
    private static final DateTimeFormatter DATEFORMAT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z (zzz)", Locale.US);
    private static final String EHLO = "EHLO";
    private static final String SMTP = "SMTP";
    private static final String ESMTPA = "ESMTPA";
    private static final String ESMTPSA = "ESMTPSA";
    private static final String ESMTP = "ESMTP";
    private static final String ESMTPS = "ESMTPS";
    private final ProtocolSession.AttachmentKey<Integer> mtPriority = ProtocolSession.AttachmentKey.of((String)"MT-PRIORITY", Integer.class);

    protected String getServiceType(SMTPSession session, String heloMode) {
        if (EHLO.equals(heloMode)) {
            if (session.getUsername() == null) {
                if (session.isTLSStarted()) {
                    return ESMTPS;
                }
                return ESMTP;
            }
            if (session.isTLSStarted()) {
                return ESMTPSA;
            }
            return ESMTPA;
        }
        return SMTP;
    }

    public ReceivedDataLineFilter.Header generateReceivedHeader(SMTPSession session) {
        StringBuilder headerLineBuffer = new StringBuilder();
        Optional heloMode = session.getAttachment(SMTPSession.CURRENT_HELO_MODE, ProtocolSession.State.Connection);
        Optional heloName = session.getAttachment(SMTPSession.CURRENT_HELO_NAME, ProtocolSession.State.Connection);
        headerLineBuffer.append("from ").append(session.getRemoteAddress().getHostName());
        if (heloName.isPresent() && heloMode.isPresent()) {
            headerLineBuffer.append(" (").append((String)heloMode.get()).append(" ").append((String)heloName.get()).append(")");
        }
        headerLineBuffer.append(" ([").append(session.getRemoteAddress().getAddress().getHostAddress()).append("])");
        ReceivedDataLineFilter.Header header = new ReceivedDataLineFilter.Header("Received", headerLineBuffer.toString());
        headerLineBuffer = new StringBuilder();
        session.getSSLSession().map(sslSession -> String.format("(using %s with cipher %s)", sslSession.getProtocol(), Optional.ofNullable(sslSession.getCipherSuite()).orElse(""))).ifPresent(header::add);
        headerLineBuffer.append("by ").append(session.getConfiguration().getHelloName()).append(" (").append(session.getConfiguration().getSoftwareName()).append(") with ").append(this.getServiceType(session, heloMode.orElse("NOT-DEFINED")));
        headerLineBuffer.append(" ID ").append(session.getSessionID());
        List rcptList = (List)session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
        String priorityValue = session.getAttachment(this.mtPriority, ProtocolSession.State.Transaction).map(p -> " (PRIORITY " + p + ")").orElse("");
        if (rcptList.size() == 1) {
            header.add(headerLineBuffer.toString());
            headerLineBuffer = new StringBuilder();
            headerLineBuffer.append("for <").append(((MailAddress)rcptList.getFirst()).toString()).append(">");
            headerLineBuffer.append(priorityValue).append(";");
        } else {
            headerLineBuffer.append(priorityValue).append(";");
        }
        header.add(headerLineBuffer.toString());
        headerLineBuffer = new StringBuilder();
        headerLineBuffer.append(DATEFORMAT.format(ZonedDateTime.now()));
        header.add(headerLineBuffer.toString());
        return header;
    }
}

