/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.compiler.JavaFactory;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.OptimizerFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompilerFactory;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.VisitableFilter;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementGenericPermission;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRolePermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.shared.common.error.StandardException;

public class CompilerContextImpl
extends ContextImpl
implements CompilerContext {
    private static final int SCOPE_CELL = 0;
    private final Parser parser;
    private final LanguageConnectionContext lcc;
    private final LanguageConnectionFactory lcf;
    private TypeCompilerFactory typeCompilerFactory;
    private Dependent currentDependent;
    private DependencyManager dm;
    private boolean firstOnStack;
    private boolean inUse;
    private int reliability = 1024;
    private int nextColumnNumber = 1;
    private int nextTableNumber;
    private int nextSubqueryNumber;
    private int nextResultSetNumber;
    private int scanIsolationLevel;
    private int nextEquivalenceClass = -1;
    private long nextClassName;
    private List<Object> savedObjects;
    private String classPrefix;
    private SchemaDescriptor compilationSchema;
    private ArrayList<VisitableFilter> privilegeCheckFilters;
    private HashMap<String, int[]> namedScopes;
    private boolean skippingTypePrivileges;
    private ArrayList<SchemaDescriptor> defaultSchemaStack;
    private ProviderList currentAPL;
    private boolean returnParameterFlag;
    private final HashMap<Long, StoreCostController> storeCostControllers = new HashMap();
    private SortCostController sortCostController;
    private List<ParameterNode> parameterList;
    private DataTypeDescriptor[] parameterDescriptors;
    private Object cursorInfo;
    private SQLWarning warnings;
    private final ArrayList<Integer> privTypeStack = new ArrayList();
    private int currPrivType = -1;
    private HashMap<StatementTablePermission, StatementColumnPermission> requiredColumnPrivileges;
    private HashMap<StatementTablePermission, StatementTablePermission> requiredTablePrivileges;
    private HashMap<StatementSchemaPermission, StatementSchemaPermission> requiredSchemaPrivileges;
    private HashMap<UUID, Integer> requiredRoutinePrivileges;
    private HashMap<UUID, String> requiredUsagePrivileges;
    private HashMap<StatementRolePermission, StatementRolePermission> requiredRolePrivileges;
    private HashMap<UUID, SequenceDescriptor> referencedSequences;

    @Override
    public void cleanupOnError(Throwable throwable) throws StandardException {
        this.setInUse(false);
        this.resetContext();
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            int n = standardException.getSeverity();
            if (n < 50000) {
                if (this.currentDependent != null) {
                    this.currentDependent.makeInvalid(0, this.lcc);
                }
                this.closeStoreCostControllers();
                this.closeSortCostControllers();
            }
            if (n >= 40000) {
                this.popMe();
            }
        }
    }

    @Override
    public void resetContext() {
        this.nextColumnNumber = 1;
        this.nextTableNumber = 0;
        this.nextSubqueryNumber = 0;
        this.resetNextResultSetNumber();
        this.nextEquivalenceClass = -1;
        this.compilationSchema = null;
        this.parameterList = null;
        this.parameterDescriptors = null;
        this.scanIsolationLevel = 0;
        this.warnings = null;
        this.savedObjects = null;
        this.reliability = 1024;
        this.returnParameterFlag = false;
        this.initRequiredPriv();
        this.defaultSchemaStack = null;
        this.referencedSequences = null;
        this.privilegeCheckFilters = null;
        this.namedScopes = null;
        this.skippingTypePrivileges = false;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }

    @Override
    public OptimizerFactory getOptimizerFactory() {
        return this.lcf.getOptimizerFactory();
    }

    @Override
    public int getNextColumnNumber() {
        return this.nextColumnNumber++;
    }

    @Override
    public int getNextTableNumber() {
        return this.nextTableNumber++;
    }

    @Override
    public int getNumTables() {
        return this.nextTableNumber;
    }

    @Override
    public int getNextSubqueryNumber() {
        return this.nextSubqueryNumber++;
    }

    @Override
    public int getNumSubquerys() {
        return this.nextSubqueryNumber;
    }

    @Override
    public int getNextResultSetNumber() {
        return this.nextResultSetNumber++;
    }

    @Override
    public void resetNextResultSetNumber() {
        this.nextResultSetNumber = 0;
    }

    @Override
    public int getNumResultSets() {
        return this.nextResultSetNumber;
    }

    @Override
    public String getUniqueClassName() {
        return this.classPrefix.concat(Long.toHexString(this.nextClassName++));
    }

    @Override
    public int getNextEquivalenceClass() {
        return ++this.nextEquivalenceClass;
    }

    @Override
    public ClassFactory getClassFactory() {
        return this.lcf.getClassFactory();
    }

    @Override
    public JavaFactory getJavaFactory() {
        return this.lcf.getJavaFactory();
    }

    @Override
    public void setCurrentDependent(Dependent dependent) {
        this.currentDependent = dependent;
    }

    @Override
    public ProviderList getCurrentAuxiliaryProviderList() {
        return this.currentAPL;
    }

    @Override
    public void setCurrentAuxiliaryProviderList(ProviderList providerList) {
        this.currentAPL = providerList;
    }

    @Override
    public void createDependency(Provider provider) throws StandardException {
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(this.currentDependent, provider, this.getContextManager());
        this.addProviderToAuxiliaryList(provider);
    }

    @Override
    public void createDependency(Dependent dependent, Provider provider) throws StandardException {
        if (this.dm == null) {
            this.dm = this.lcc.getDataDictionary().getDependencyManager();
        }
        this.dm.addDependency(dependent, provider, this.getContextManager());
        this.addProviderToAuxiliaryList(provider);
    }

    private void addProviderToAuxiliaryList(Provider provider) {
        if (this.currentAPL != null) {
            this.currentAPL.addProvider(provider);
        }
    }

    @Override
    public int addSavedObject(Object object) {
        if (this.savedObjects == null) {
            this.savedObjects = new ArrayList<Object>();
        }
        this.savedObjects.add(object);
        return this.savedObjects.size() - 1;
    }

    @Override
    public Object[] getSavedObjects() {
        if (this.savedObjects == null) {
            return null;
        }
        Object[] objectArray = this.savedObjects.toArray();
        this.savedObjects = null;
        return objectArray;
    }

    @Override
    public void setSavedObjects(List<Object> list) {
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addSavedObject(iterator.next());
        }
    }

    @Override
    public void setCursorInfo(Object object) {
        this.cursorInfo = object;
    }

    @Override
    public Object getCursorInfo() {
        return this.cursorInfo;
    }

    @Override
    public void firstOnStack() {
        this.firstOnStack = true;
    }

    @Override
    public boolean isFirstOnStack() {
        return this.firstOnStack;
    }

    @Override
    public void setInUse(boolean bl) {
        this.inUse = bl;
        if (!bl) {
            this.closeStoreCostControllers();
            this.closeSortCostControllers();
        }
    }

    @Override
    public boolean getInUse() {
        return this.inUse;
    }

    @Override
    public void setReliability(int n) {
        this.reliability = n;
    }

    @Override
    public int getReliability() {
        return this.reliability;
    }

    @Override
    public StoreCostController getStoreCostController(long l) throws StandardException {
        Long l2 = l;
        StoreCostController storeCostController = this.storeCostControllers.get(l2);
        if (storeCostController == null) {
            storeCostController = this.lcc.getTransactionCompile().openStoreCost(l);
            this.storeCostControllers.put(l2, storeCostController);
        }
        return storeCostController;
    }

    private void closeStoreCostControllers() {
        for (StoreCostController storeCostController : this.storeCostControllers.values()) {
            try {
                storeCostController.close();
            }
            catch (StandardException standardException) {}
        }
        this.storeCostControllers.clear();
    }

    @Override
    public SortCostController getSortCostController() throws StandardException {
        if (this.sortCostController == null) {
            this.sortCostController = this.lcc.getTransactionCompile().openSortCostController();
        }
        return this.sortCostController;
    }

    private void closeSortCostControllers() {
        if (this.sortCostController != null) {
            this.sortCostController.close();
            this.sortCostController = null;
        }
    }

    @Override
    public SchemaDescriptor getCompilationSchema() {
        return this.compilationSchema;
    }

    @Override
    public SchemaDescriptor setCompilationSchema(SchemaDescriptor schemaDescriptor) {
        SchemaDescriptor schemaDescriptor2 = this.compilationSchema;
        this.compilationSchema = schemaDescriptor;
        return schemaDescriptor2;
    }

    @Override
    public void pushCompilationSchema(SchemaDescriptor schemaDescriptor) {
        if (this.defaultSchemaStack == null) {
            this.defaultSchemaStack = new ArrayList(2);
        }
        this.defaultSchemaStack.add(this.defaultSchemaStack.size(), this.getCompilationSchema());
        this.setCompilationSchema(schemaDescriptor);
    }

    @Override
    public void popCompilationSchema() {
        SchemaDescriptor schemaDescriptor = this.defaultSchemaStack.remove(this.defaultSchemaStack.size() - 1);
        this.setCompilationSchema(schemaDescriptor);
    }

    @Override
    public void setParameterList(List<ParameterNode> list) {
        int n;
        this.parameterList = list;
        int n2 = n = list == null ? 0 : list.size();
        if (n > 0) {
            this.parameterDescriptors = new DataTypeDescriptor[n];
        }
    }

    @Override
    public List<ParameterNode> getParameterList() {
        return this.parameterList;
    }

    @Override
    public void setReturnParameterFlag() {
        this.returnParameterFlag = true;
    }

    @Override
    public boolean getReturnParameterFlag() {
        return this.returnParameterFlag;
    }

    DataTypeDescriptor[] getParameterTypes() {
        return this.parameterDescriptors;
    }

    @Override
    public void setScanIsolationLevel(int n) {
        this.scanIsolationLevel = n;
    }

    @Override
    public int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    @Override
    public TypeCompilerFactory getTypeCompilerFactory() {
        return this.typeCompilerFactory;
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public CompilerContextImpl(ContextManager contextManager, LanguageConnectionContext languageConnectionContext, TypeCompilerFactory typeCompilerFactory) {
        super(contextManager, "CompilerContext");
        this.lcc = languageConnectionContext;
        this.lcf = languageConnectionContext.getLanguageConnectionFactory();
        this.parser = this.lcf.newParser(this);
        this.typeCompilerFactory = typeCompilerFactory;
        this.classPrefix = "ac" + this.lcf.getUUIDFactory().createUUID().toString().replace('-', 'x');
        this.initRequiredPriv();
    }

    private void initRequiredPriv() {
        this.currPrivType = -1;
        this.privTypeStack.clear();
        this.requiredColumnPrivileges = null;
        this.requiredTablePrivileges = null;
        this.requiredSchemaPrivileges = null;
        this.requiredRoutinePrivileges = null;
        this.requiredUsagePrivileges = null;
        this.requiredRolePrivileges = null;
        if (this.lcc.usesSqlAuthorization()) {
            this.requiredColumnPrivileges = new HashMap();
            this.requiredTablePrivileges = new HashMap();
            this.requiredSchemaPrivileges = new HashMap();
            this.requiredRoutinePrivileges = new HashMap();
            this.requiredUsagePrivileges = new HashMap();
            this.requiredRolePrivileges = new HashMap();
        }
    }

    @Override
    public void pushCurrentPrivType(int n) {
        this.privTypeStack.add(this.currPrivType);
        this.currPrivType = n;
    }

    @Override
    public void popCurrentPrivType() {
        Integer n = this.privTypeStack.remove(this.privTypeStack.size() - 1);
        this.currPrivType = n;
    }

    @Override
    public void addRequiredColumnPriv(ColumnDescriptor columnDescriptor) {
        StatementColumnPermission statementColumnPermission;
        StatementTablePermission statementTablePermission;
        if (this.requiredColumnPrivileges == null || this.currPrivType == -1 || this.currPrivType == 4 || this.currPrivType == 3 || this.currPrivType == 5 || this.currPrivType == 6 || columnDescriptor == null) {
            return;
        }
        TableDescriptor tableDescriptor = columnDescriptor.getTableDescriptor();
        if (tableDescriptor == null) {
            return;
        }
        if (tableDescriptor.getTableType() == 3) {
            return;
        }
        UUID uUID = tableDescriptor.getUUID();
        if (this.currPrivType == 8 && (this.requiredColumnPrivileges.containsKey(statementTablePermission = new StatementTablePermission(uUID, 0)) || this.requiredTablePrivileges.containsKey(statementTablePermission))) {
            return;
        }
        if (this.currPrivType == 0) {
            statementTablePermission = new StatementTablePermission(uUID, 8);
            this.requiredColumnPrivileges.remove(statementTablePermission);
        }
        if ((statementColumnPermission = this.requiredColumnPrivileges.get(statementTablePermission = new StatementTablePermission(uUID, this.currPrivType))) == null) {
            statementColumnPermission = new StatementColumnPermission(uUID, this.currPrivType, new FormatableBitSet(tableDescriptor.getNumberOfColumns()));
            this.requiredColumnPrivileges.put(statementTablePermission, statementColumnPermission);
        }
        statementColumnPermission.getColumns().set(columnDescriptor.getPosition() - 1);
    }

    @Override
    public void addRequiredTablePriv(TableDescriptor tableDescriptor) {
        StatementTablePermission statementTablePermission;
        if (this.requiredTablePrivileges == null || tableDescriptor == null) {
            return;
        }
        if (tableDescriptor.getTableType() == 3) {
            return;
        }
        if (this.currPrivType == 0) {
            statementTablePermission = new StatementTablePermission(tableDescriptor.getUUID(), 8);
            this.requiredColumnPrivileges.remove(statementTablePermission);
        }
        statementTablePermission = new StatementTablePermission(tableDescriptor.getUUID(), this.currPrivType);
        this.requiredTablePrivileges.put(statementTablePermission, statementTablePermission);
    }

    @Override
    public void addRequiredRoutinePriv(AliasDescriptor aliasDescriptor) {
        if (this.requiredRoutinePrivileges == null || aliasDescriptor == null) {
            return;
        }
        if (aliasDescriptor.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30")) {
            return;
        }
        if (this.requiredRoutinePrivileges.get(aliasDescriptor.getUUID()) == null) {
            this.requiredRoutinePrivileges.put(aliasDescriptor.getUUID(), 1);
        }
    }

    @Override
    public void addRequiredUsagePriv(PrivilegedSQLObject privilegedSQLObject) {
        if (this.requiredUsagePrivileges == null || privilegedSQLObject == null) {
            return;
        }
        UUID uUID = privilegedSQLObject.getUUID();
        String string = privilegedSQLObject.getObjectTypeName();
        if (this.requiredUsagePrivileges.get(uUID) == null) {
            this.requiredUsagePrivileges.put(uUID, string);
        }
    }

    @Override
    public void addRequiredSchemaPriv(String string, String string2, int n) {
        if (this.requiredSchemaPrivileges == null || string == null) {
            return;
        }
        StatementSchemaPermission statementSchemaPermission = new StatementSchemaPermission(string, string2, n);
        this.requiredSchemaPrivileges.put(statementSchemaPermission, statementSchemaPermission);
    }

    @Override
    public void addRequiredRolePriv(String string, int n) {
        if (this.requiredRolePrivileges == null) {
            return;
        }
        StatementRolePermission statementRolePermission = new StatementRolePermission(string, n);
        this.requiredRolePrivileges.put(statementRolePermission, statementRolePermission);
    }

    @Override
    public List<StatementPermission> getRequiredPermissionsList() {
        Iterator<Object> iterator;
        int n = 0;
        if (this.requiredRoutinePrivileges != null) {
            n += this.requiredRoutinePrivileges.size();
        }
        if (this.requiredUsagePrivileges != null) {
            n += this.requiredUsagePrivileges.size();
        }
        if (this.requiredTablePrivileges != null) {
            n += this.requiredTablePrivileges.size();
        }
        if (this.requiredSchemaPrivileges != null) {
            n += this.requiredSchemaPrivileges.size();
        }
        if (this.requiredColumnPrivileges != null) {
            n += this.requiredColumnPrivileges.size();
        }
        if (this.requiredRolePrivileges != null) {
            n += this.requiredRolePrivileges.size();
        }
        ArrayList<StatementPermission> arrayList = new ArrayList<StatementPermission>(n);
        if (this.requiredRoutinePrivileges != null) {
            for (UUID uUID : this.requiredRoutinePrivileges.keySet()) {
                arrayList.add(new StatementRoutinePermission(uUID));
            }
        }
        if (this.requiredUsagePrivileges != null) {
            for (UUID uUID : this.requiredUsagePrivileges.keySet()) {
                arrayList.add(new StatementGenericPermission(uUID, this.requiredUsagePrivileges.get(uUID), "USAGE"));
            }
        }
        if (this.requiredTablePrivileges != null) {
            iterator = this.requiredTablePrivileges.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add((StatementPermission)iterator.next());
            }
        }
        if (this.requiredSchemaPrivileges != null) {
            iterator = this.requiredSchemaPrivileges.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add((StatementPermission)iterator.next());
            }
        }
        if (this.requiredColumnPrivileges != null) {
            iterator = this.requiredColumnPrivileges.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add((StatementPermission)iterator.next());
            }
        }
        if (this.requiredRolePrivileges != null) {
            iterator = this.requiredRolePrivileges.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add((StatementPermission)iterator.next());
            }
        }
        return arrayList;
    }

    @Override
    public void addReferencedSequence(SequenceDescriptor sequenceDescriptor) {
        if (this.referencedSequences == null) {
            this.referencedSequences = new HashMap();
        }
        this.referencedSequences.put(sequenceDescriptor.getUUID(), sequenceDescriptor);
    }

    @Override
    public boolean isReferenced(SequenceDescriptor sequenceDescriptor) {
        if (this.referencedSequences == null) {
            return false;
        }
        return this.referencedSequences.containsKey(sequenceDescriptor.getUUID());
    }

    @Override
    public void addPrivilegeFilter(VisitableFilter visitableFilter) {
        if (this.privilegeCheckFilters == null) {
            this.privilegeCheckFilters = new ArrayList();
        }
        this.privilegeCheckFilters.add(visitableFilter);
    }

    @Override
    public void removePrivilegeFilter(VisitableFilter visitableFilter) {
        if (visitableFilter != null && this.privilegeCheckFilters != null) {
            this.privilegeCheckFilters.remove(visitableFilter);
        }
    }

    @Override
    public boolean passesPrivilegeFilters(Visitable visitable) throws StandardException {
        if (this.privilegeCheckFilters == null) {
            return true;
        }
        for (VisitableFilter visitableFilter : this.privilegeCheckFilters) {
            if (visitableFilter.accept(visitable)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void beginScope(String string) {
        int[] nArray;
        if (this.namedScopes == null) {
            this.namedScopes = new HashMap();
        }
        if ((nArray = this.namedScopes.get(string)) == null) {
            nArray = new int[1];
            this.namedScopes.put(string, nArray);
        }
        nArray[0] = nArray[0] + 1;
    }

    @Override
    public void endScope(String string) {
        if (this.namedScopes == null) {
            return;
        }
        int[] nArray = this.namedScopes.get(string);
        if (nArray == null) {
            return;
        }
        nArray[0] = nArray[0] - 1;
        if (nArray[0] <= 0) {
            this.namedScopes.remove(string);
        }
    }

    @Override
    public int scopeDepth(String string) {
        if (this.namedScopes == null) {
            return 0;
        }
        int[] nArray = this.namedScopes.get(string);
        if (nArray == null) {
            return 0;
        }
        return nArray[0];
    }

    @Override
    public boolean skipTypePrivileges(boolean bl) {
        boolean bl2 = this.skippingTypePrivileges;
        this.skippingTypePrivileges = bl;
        return bl2;
    }

    @Override
    public boolean skippingTypePrivileges() {
        return this.skippingTypePrivileges;
    }
}

