/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.user;

import com.google.common.collect.ImmutableList;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import java.util.List;
import java.util.Optional;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.user.model.JPASubscription;
import org.apache.james.mailbox.store.user.SubscriptionMapper;
import org.apache.james.mailbox.store.user.model.Subscription;

public class JPASubscriptionMapper
extends JPATransactionalMapper
implements SubscriptionMapper {
    public JPASubscriptionMapper(EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
    }

    public void save(Subscription subscription) throws SubscriptionException {
        boolean localTransaction;
        EntityManager entityManager = this.getEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        boolean bl = localTransaction = !transaction.isActive();
        if (localTransaction) {
            transaction.begin();
        }
        try {
            if (!this.exists(entityManager, subscription)) {
                entityManager.persist((Object)new JPASubscription(subscription));
            }
            if (localTransaction && transaction.isActive()) {
                transaction.commit();
            }
        }
        catch (PersistenceException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public List<Subscription> findSubscriptionsForUser(Username user) throws SubscriptionException {
        try {
            return (List)this.getEntityManager().createNamedQuery("findSubscriptionsForUser", JPASubscription.class).setParameter("userParam", (Object)user.asString()).getResultList().stream().map(JPASubscription::toSubscription).collect(ImmutableList.toImmutableList());
        }
        catch (PersistenceException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    public void delete(Subscription subscription) throws SubscriptionException {
        boolean localTransaction;
        EntityManager entityManager = this.getEntityManager();
        EntityTransaction transaction = entityManager.getTransaction();
        boolean bl = localTransaction = !transaction.isActive();
        if (localTransaction) {
            transaction.begin();
        }
        try {
            this.findJpaSubscription(entityManager, subscription).ifPresent(arg_0 -> ((EntityManager)entityManager).remove(arg_0));
            if (localTransaction && transaction.isActive()) {
                transaction.commit();
            }
        }
        catch (PersistenceException e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new SubscriptionException((Exception)((Object)e));
        }
    }

    private Optional<JPASubscription> findJpaSubscription(EntityManager entityManager, Subscription subscription) {
        return entityManager.createNamedQuery("findFindMailboxSubscriptionForUser", JPASubscription.class).setParameter("userParam", (Object)subscription.getUser().asString()).setParameter("mailboxParam", (Object)subscription.getMailbox()).getResultList().stream().findFirst();
    }

    private boolean exists(EntityManager entityManager, Subscription subscription) throws SubscriptionException {
        try {
            return !entityManager.createNamedQuery("findFindMailboxSubscriptionForUser", JPASubscription.class).setParameter("userParam", (Object)subscription.getUser().asString()).setParameter("mailboxParam", (Object)subscription.getMailbox()).getResultList().isEmpty();
        }
        catch (NoResultException e) {
            return false;
        }
        catch (PersistenceException e) {
            throw new SubscriptionException((Exception)((Object)e));
        }
    }
}

