/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import java.time.LocalDateTime;
import java.util.UUID;
import org.apache.james.backends.postgres.PostgresCommons;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.apache.james.mailbox.postgres.mail.dto.AttachmentsDTO;
import org.jooq.Binding;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.postgres.extensions.types.Hstore;

public interface PostgresMessageDataDefinition {
    public static final Field<UUID> MESSAGE_ID = DSL.field((String)"message_id", (DataType)SQLDataType.UUID.notNull());
    public static final Field<LocalDateTime> INTERNAL_DATE = DSL.field((String)"internal_date", (DataType)PostgresCommons.DataTypes.TIMESTAMP);
    public static final Field<Long> SIZE = DSL.field((String)"size", (DataType)SQLDataType.BIGINT.notNull());
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{MessageTable.TABLE}).addTable(new PostgresTable[]{MessageToMailboxTable.TABLE}).addIndex(new PostgresIndex[]{MessageToMailboxTable.MESSAGE_ID_INDEX}).addIndex(new PostgresIndex[]{MessageToMailboxTable.MAILBOX_ID_MESSAGE_UID_INDEX}).addIndex(new PostgresIndex[]{MessageToMailboxTable.MAILBOX_ID_IS_SEEN_MESSAGE_UID_INDEX}).addIndex(new PostgresIndex[]{MessageToMailboxTable.MAILBOX_ID_IS_RECENT_MESSAGE_UID_INDEX}).addIndex(new PostgresIndex[]{MessageToMailboxTable.MAILBOX_ID_IS_DELETE_MESSAGE_UID_INDEX}).build();

    public static interface MessageTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"message");
        public static final Field<UUID> MESSAGE_ID = MESSAGE_ID;
        public static final Field<String> BODY_BLOB_ID = DSL.field((String)"body_blob_id", (DataType)SQLDataType.VARCHAR((int)200).notNull());
        public static final Field<String> MIME_TYPE = DSL.field((String)"mime_type", (DataType)SQLDataType.VARCHAR((int)200));
        public static final Field<String> MIME_SUBTYPE = DSL.field((String)"mime_subtype", (DataType)SQLDataType.VARCHAR((int)200));
        public static final Field<LocalDateTime> INTERNAL_DATE = INTERNAL_DATE;
        public static final Field<Long> SIZE = SIZE;
        public static final Field<Integer> BODY_START_OCTET = DSL.field((String)"body_start_octet", (DataType)SQLDataType.INTEGER.notNull());
        public static final Field<byte[]> HEADER_CONTENT = DSL.field((String)"header_content", (DataType)SQLDataType.BLOB.notNull());
        public static final Field<Integer> TEXTUAL_LINE_COUNT = DSL.field((String)"textual_line_count", (DataType)SQLDataType.INTEGER);
        public static final Field<String> CONTENT_DESCRIPTION = DSL.field((String)"content_description", (DataType)SQLDataType.VARCHAR((int)200));
        public static final Field<String> CONTENT_LOCATION = DSL.field((String)"content_location", (DataType)SQLDataType.VARCHAR((int)200));
        public static final Field<String> CONTENT_TRANSFER_ENCODING = DSL.field((String)"content_transfer_encoding", (DataType)SQLDataType.VARCHAR((int)200));
        public static final Field<String> CONTENT_DISPOSITION_TYPE = DSL.field((String)"content_disposition_type", (DataType)SQLDataType.VARCHAR((int)200));
        public static final Field<String> CONTENT_ID = DSL.field((String)"content_id", (DataType)SQLDataType.VARCHAR((int)200));
        public static final Field<String> CONTENT_MD5 = DSL.field((String)"content_md5", (DataType)SQLDataType.VARCHAR((int)200));
        public static final Field<String[]> CONTENT_LANGUAGE = DSL.field((String)"content_language", (DataType)PostgresCommons.DataTypes.STRING_ARRAY);
        public static final Field<Hstore> CONTENT_TYPE_PARAMETERS = DSL.field((String)"content_type_parameters", (DataType)PostgresCommons.DataTypes.HSTORE);
        public static final Field<Hstore> CONTENT_DISPOSITION_PARAMETERS = DSL.field((String)"content_disposition_parameters", (DataType)PostgresCommons.DataTypes.HSTORE);
        public static final Field<AttachmentsDTO> ATTACHMENT_METADATA = DSL.field((String)"attachment_metadata", (DataType)SQLDataType.JSONB.asConvertedDataType((Binding)new AttachmentsDTO.AttachmentsDTOBinding()));
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(MESSAGE_ID).column(BODY_BLOB_ID).column(MIME_TYPE).column(MIME_SUBTYPE).column(INTERNAL_DATE).column(SIZE).column(BODY_START_OCTET).column(HEADER_CONTENT).column(TEXTUAL_LINE_COUNT).column(CONTENT_DESCRIPTION).column(CONTENT_LOCATION).column(CONTENT_TRANSFER_ENCODING).column(CONTENT_DISPOSITION_TYPE).column(CONTENT_ID).column(CONTENT_MD5).column(CONTENT_LANGUAGE).column(CONTENT_TYPE_PARAMETERS).column(CONTENT_DISPOSITION_PARAMETERS).column(ATTACHMENT_METADATA).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{MESSAGE_ID})).comment("Holds the metadata of a mail")).supportsRowLevelSecurity().build();
    }

    public static interface MessageToMailboxTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"message_mailbox");
        public static final Field<UUID> MAILBOX_ID = DSL.field((String)"mailbox_id", (DataType)SQLDataType.UUID.notNull());
        public static final Field<Long> MESSAGE_UID = DSL.field((String)"message_uid", (DataType)SQLDataType.BIGINT.notNull());
        public static final Field<Long> MOD_SEQ = DSL.field((String)"mod_seq", (DataType)SQLDataType.BIGINT.notNull());
        public static final Field<UUID> MESSAGE_ID = MESSAGE_ID;
        public static final Field<UUID> THREAD_ID = DSL.field((String)"thread_id", (DataType)SQLDataType.UUID);
        public static final Field<LocalDateTime> INTERNAL_DATE = INTERNAL_DATE;
        public static final Field<Long> SIZE = SIZE;
        public static final Field<Boolean> IS_DELETED = DSL.field((String)"is_deleted", (DataType)SQLDataType.BOOLEAN.nullable(false).defaultValue(DSL.field((String)"false", (DataType)SQLDataType.BOOLEAN)));
        public static final Field<Boolean> IS_ANSWERED = DSL.field((String)"is_answered", (DataType)SQLDataType.BOOLEAN.nullable(false));
        public static final Field<Boolean> IS_DRAFT = DSL.field((String)"is_draft", (DataType)SQLDataType.BOOLEAN.nullable(false));
        public static final Field<Boolean> IS_FLAGGED = DSL.field((String)"is_flagged", (DataType)SQLDataType.BOOLEAN.nullable(false));
        public static final Field<Boolean> IS_RECENT = DSL.field((String)"is_recent", (DataType)SQLDataType.BOOLEAN.nullable(false));
        public static final Field<Boolean> IS_SEEN = DSL.field((String)"is_seen", (DataType)SQLDataType.BOOLEAN.nullable(false));
        public static final Field<String[]> USER_FLAGS = DSL.field((String)"user_flags", (DataType)PostgresCommons.DataTypes.STRING_ARRAY);
        public static final Field<LocalDateTime> SAVE_DATE = DSL.field((String)"save_date", (DataType)PostgresCommons.DataTypes.TIMESTAMP);
        public static final String REMOVE_ELEMENTS_FROM_ARRAY_FUNCTION_NAME = "remove_elements_from_array";
        public static final String CREATE_ARRAY_REMOVE_JAMES_FUNCTION = "CREATE OR REPLACE FUNCTION remove_elements_from_array(\n    source text[],\n    elements_to_remove text[])\n    RETURNS text[]\nAS\n$$\nDECLARE\n    result text[];\nBEGIN\n    select array_agg(elements) INTO result\n    from (select unnest(source)\n          except\n          select unnest(elements_to_remove)) t (elements);\n    RETURN result;\nEND;\n$$ LANGUAGE plpgsql;";
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(MAILBOX_ID).column(MESSAGE_UID).column(MOD_SEQ).column(MESSAGE_ID).column(THREAD_ID).column(INTERNAL_DATE).column(SIZE).column(IS_DELETED).column(IS_ANSWERED).column(IS_DRAFT).column(IS_FLAGGED).column(IS_RECENT).column(IS_SEEN).column(USER_FLAGS).column(SAVE_DATE).constraints(new Constraint[]{DSL.primaryKey((Field[])new Field[]{MAILBOX_ID, MESSAGE_UID}), DSL.foreignKey(MESSAGE_ID).references(MessageTable.TABLE_NAME, MessageTable.MESSAGE_ID)}).comment("Holds mailbox and flags for each message")).supportsRowLevelSecurity().addAdditionalAlterQueries(new String[]{"CREATE OR REPLACE FUNCTION remove_elements_from_array(\n    source text[],\n    elements_to_remove text[])\n    RETURNS text[]\nAS\n$$\nDECLARE\n    result text[];\nBEGIN\n    select array_agg(elements) INTO result\n    from (select unnest(source)\n          except\n          select unnest(elements_to_remove)) t (elements);\n    RETURN result;\nEND;\n$$ LANGUAGE plpgsql;"}).build();
        public static final PostgresIndex MESSAGE_ID_INDEX = PostgresIndex.name((String)"message_mailbox_message_id_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MESSAGE_ID}));
        public static final PostgresIndex MAILBOX_ID_MESSAGE_UID_INDEX = PostgresIndex.name((String)"mailbox_id_mail_uid_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MAILBOX_ID, MESSAGE_UID.asc()}));
        public static final PostgresIndex MAILBOX_ID_IS_SEEN_MESSAGE_UID_INDEX = PostgresIndex.name((String)"mailbox_id_is_seen_mail_uid_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MAILBOX_ID, IS_SEEN, MESSAGE_UID.asc()}));
        public static final PostgresIndex MAILBOX_ID_IS_RECENT_MESSAGE_UID_INDEX = PostgresIndex.name((String)"mailbox_id_is_recent_mail_uid_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MAILBOX_ID, IS_RECENT, MESSAGE_UID.asc()}));
        public static final PostgresIndex MAILBOX_ID_IS_DELETE_MESSAGE_UID_INDEX = PostgresIndex.name((String)"mailbox_id_is_delete_mail_uid_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{MAILBOX_ID, IS_DELETED, MESSAGE_UID.asc()}));
    }
}

