/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.opensearch.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.github.fge.lambdas.Throwing;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.mail.Flags;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.function.Function;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.opensearch.IndexAttachments;
import org.apache.james.mailbox.opensearch.IndexBody;
import org.apache.james.mailbox.opensearch.IndexHeaders;
import org.apache.james.mailbox.opensearch.OpenSearchMailboxConfiguration;
import org.apache.james.mailbox.opensearch.json.IndexableMessage;
import org.apache.james.mailbox.opensearch.json.MessageUpdateJson;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import reactor.core.publisher.Mono;

public class MessageToOpenSearchJson {
    private final ObjectMapper mapper;
    private final TextExtractor textExtractor;
    private final ZoneId zoneId;
    private final IndexAttachments indexAttachments;
    private final IndexHeaders indexHeaders;
    private final IndexBody indexBody;
    private final IndexUser indexUser;

    public MessageToOpenSearchJson(TextExtractor textExtractor, ZoneId zoneId, IndexAttachments indexAttachments, IndexHeaders indexHeaders) {
        this(textExtractor, zoneId, indexAttachments, indexHeaders, IndexBody.YES);
    }

    public MessageToOpenSearchJson(TextExtractor textExtractor, ZoneId zoneId, IndexAttachments indexAttachments, IndexHeaders indexHeaders, IndexBody indexBody) {
        this(textExtractor, zoneId, indexAttachments, indexHeaders, indexBody, IndexUser.YES);
    }

    public MessageToOpenSearchJson(TextExtractor textExtractor, ZoneId zoneId, IndexAttachments indexAttachments, IndexHeaders indexHeaders, IndexBody indexBody, IndexUser indexUser) {
        this.textExtractor = textExtractor;
        this.zoneId = zoneId;
        this.indexAttachments = indexAttachments;
        this.indexHeaders = indexHeaders;
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new GuavaModule());
        this.mapper.registerModule((Module)new Jdk8Module());
        this.indexBody = indexBody;
        this.indexUser = indexUser;
    }

    @Inject
    public MessageToOpenSearchJson(TextExtractor textExtractor, OpenSearchMailboxConfiguration configuration) {
        this(textExtractor, ZoneId.systemDefault(), configuration.getIndexAttachment(), configuration.getIndexHeaders(), configuration.getIndexBody(), configuration.getIndexUser());
    }

    public Mono<String> convertToJson(MailboxMessage message, MailboxSession session) {
        Preconditions.checkNotNull((Object)message);
        return IndexableMessage.builder().message(message).extractor(this.textExtractor).zoneId(this.zoneId).indexAttachments(this.indexAttachments).indexHeaders(this.indexHeaders).indexBody(this.indexBody).user(this.indexUser, session.getUser().asString()).build().map((Function)Throwing.function(arg_0 -> ((ObjectMapper)this.mapper).writeValueAsString(arg_0)));
    }

    public Mono<String> convertToJsonWithoutAttachment(MailboxMessage message, MailboxSession session) {
        return IndexableMessage.builder().message(message).extractor(this.textExtractor).zoneId(this.zoneId).indexAttachments(IndexAttachments.NO).indexHeaders(this.indexHeaders).user(this.indexUser, session.getUser().asString()).indexBody(this.indexBody).build().map((Function)Throwing.function(arg_0 -> ((ObjectMapper)this.mapper).writeValueAsString(arg_0)));
    }

    public Mono<String> convertToJson(MailboxMessage message) {
        Preconditions.checkNotNull((Object)message);
        return IndexableMessage.builder().message(message).extractor(this.textExtractor).zoneId(this.zoneId).indexAttachments(this.indexAttachments).indexHeaders(this.indexHeaders).indexBody(this.indexBody).build().map((Function)Throwing.function(arg_0 -> ((ObjectMapper)this.mapper).writeValueAsString(arg_0)));
    }

    public Mono<String> convertToJsonWithoutAttachment(MailboxMessage message) {
        return IndexableMessage.builder().message(message).extractor(this.textExtractor).zoneId(this.zoneId).indexAttachments(IndexAttachments.NO).indexHeaders(this.indexHeaders).indexBody(this.indexBody).build().map((Function)Throwing.function(arg_0 -> ((ObjectMapper)this.mapper).writeValueAsString(arg_0)));
    }

    public String getUpdatedJsonMessagePart(Flags flags, ModSeq modSeq) throws JsonProcessingException {
        Preconditions.checkNotNull((Object)flags);
        return this.mapper.writeValueAsString((Object)new MessageUpdateJson(flags, modSeq));
    }

    public ObjectNode updateMailboxId(ObjectNode origin, MailboxId newMailboxId) {
        origin.put("mailboxId", newMailboxId.serialize());
        return origin;
    }

    public ObjectNode updateSaveDate(ObjectNode origin, Date newSaveDate) {
        origin.put("saveDate", IndexableMessage.DATE_TIME_FORMATTER.format(ZonedDateTime.ofInstant(newSaveDate.toInstant(), this.zoneId)));
        return origin;
    }

    public ObjectNode updateMessageUid(ObjectNode origin, MessageUid newMessageUid) {
        origin.put("uid", newMessageUid.asLong());
        return origin;
    }

    public String toString(ObjectNode objectNode) {
        return (String)Throwing.supplier(() -> this.mapper.writeValueAsString((Object)objectNode)).get();
    }

    public static enum IndexUser {
        YES,
        NO;

    }
}

