/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events;

import jakarta.inject.Inject;
import org.apache.james.backends.rabbitmq.RabbitMQConfiguration;
import org.apache.james.backends.rabbitmq.RabbitMQManagementAPI;
import org.apache.james.core.healthcheck.ComponentName;
import org.apache.james.core.healthcheck.HealthCheck;
import org.apache.james.core.healthcheck.Result;
import org.apache.james.events.NamingStrategy;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class RabbitMQJmapEventBusDeadLetterQueueHealthCheck
implements HealthCheck {
    public static final ComponentName COMPONENT_NAME = new ComponentName("RabbitMQJmapEventBusDeadLetterQueueHealthCheck");
    private static final String DEFAULT_VHOST = "/";
    private final RabbitMQConfiguration configuration;
    private final RabbitMQManagementAPI api;

    @Inject
    public RabbitMQJmapEventBusDeadLetterQueueHealthCheck(RabbitMQConfiguration configuration) {
        this.configuration = configuration;
        this.api = RabbitMQManagementAPI.from((RabbitMQConfiguration)configuration);
    }

    public ComponentName componentName() {
        return COMPONENT_NAME;
    }

    public Mono<Result> check() {
        return Mono.fromCallable(() -> this.api.queueDetails(this.configuration.getVhost().orElse(DEFAULT_VHOST), NamingStrategy.JMAP_NAMING_STRATEGY.deadLetterQueue().getName()).getQueueLength()).map(queueSize -> {
            if (queueSize != 0L) {
                return Result.degraded((ComponentName)COMPONENT_NAME, (String)"RabbitMQ dead letter queue of the JMAP event bus contain events. This might indicate transient failure on event processing.");
            }
            return Result.healthy((ComponentName)COMPONENT_NAME);
        }).onErrorResume(e -> Mono.just((Object)Result.unhealthy((ComponentName)COMPONENT_NAME, (String)"Error checking RabbitMQJmapEventBusDeadLetterQueueHealthCheck", (Throwable)e))).subscribeOn(Schedulers.boundedElastic());
    }
}

