/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.droplists.cassandra;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import org.apache.james.core.MailAddress;
import org.apache.james.droplists.api.DropList;
import org.apache.james.droplists.api.DropListEntry;
import org.apache.james.droplists.api.OwnerScope;
import org.apache.james.droplists.cassandra.CassandraDropListDAO;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraDropList
implements DropList {
    private final CassandraDropListDAO dropListDAO;

    @Inject
    public CassandraDropList(CassandraDropListDAO dropListDAO) {
        this.dropListDAO = dropListDAO;
    }

    public Mono<Void> add(DropListEntry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0);
        return this.dropListDAO.addDropList(entry);
    }

    public Mono<Void> remove(DropListEntry entry) {
        Preconditions.checkArgument((entry != null ? 1 : 0) != 0);
        return this.dropListDAO.removeDropList(entry);
    }

    public Flux<DropListEntry> list(OwnerScope ownerScope, String owner) {
        Preconditions.checkArgument((ownerScope != null ? 1 : 0) != 0);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        return this.dropListDAO.getDropList(ownerScope, owner);
    }

    public Mono<DropList.Status> query(OwnerScope ownerScope, String owner, MailAddress sender) {
        Preconditions.checkArgument((ownerScope != null ? 1 : 0) != 0);
        Preconditions.checkArgument((owner != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sender != null ? 1 : 0) != 0);
        return this.dropListDAO.queryDropList(ownerScope, owner, sender);
    }
}

