/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.ArrayMathFunction;
import java.util.Iterator;
import java.util.List;

public abstract class CompareFunction
extends ArrayMathFunction {
    public CompareFunction() {
        super(ArgumentConstraints.typeOf(JmesPathType.NUMBER, JmesPathType.STRING));
    }

    protected abstract boolean sortsBefore(int var1);

    @Override
    protected <T> T performMathOperation(Adapter<T> runtime, List<T> values) {
        if (values.isEmpty()) {
            return runtime.createNull();
        }
        Iterator<T> vs = values.iterator();
        T result = vs.next();
        while (vs.hasNext()) {
            T candidate = vs.next();
            if (!this.sortsBefore(runtime.compare(candidate, result))) continue;
            result = candidate;
        }
        return result;
    }
}

