/*
 * Decompiled with CFR 0.152.
 */
package jodd.buffer;

import java.util.Arrays;
import jodd.util.CharArraySequence;

public class FastCharBuffer
implements CharSequence,
Appendable {
    private char[] buffer;
    private int offset;

    public FastCharBuffer() {
        this.buffer = new char[64];
    }

    public FastCharBuffer(int size) {
        this.buffer = new char[size];
    }

    private void grow(int minCapacity) {
        int oldCapacity = this.buffer.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity + 512;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    @Override
    public FastCharBuffer append(char element) {
        if (this.offset - this.buffer.length >= 0) {
            this.grow(this.offset);
        }
        this.buffer[this.offset++] = element;
        return this;
    }

    public FastCharBuffer append(char[] array, int off, int len) {
        if (this.offset + len - this.buffer.length > 0) {
            this.grow(this.offset + len);
        }
        System.arraycopy(array, off, this.buffer, this.offset, len);
        this.offset += len;
        return this;
    }

    public FastCharBuffer append(char[] array) {
        return this.append(array, 0, array.length);
    }

    public FastCharBuffer append(FastCharBuffer buff) {
        if (buff.offset == 0) {
            return this;
        }
        this.append(buff.buffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.offset;
    }

    @Override
    public boolean isEmpty() {
        return this.offset == 0;
    }

    public void clear() {
        this.offset = 0;
    }

    public char[] toArray() {
        return Arrays.copyOf(this.buffer, this.offset);
    }

    public char[] toArray(int start, int len) {
        char[] array = new char[len];
        if (len == 0) {
            return array;
        }
        System.arraycopy(this.buffer, start, array, 0, len);
        return array;
    }

    public char get(int index) {
        if (index >= this.offset) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[index];
    }

    @Override
    public FastCharBuffer append(CharSequence csq) {
        this.append(csq, 0, csq.length());
        return this;
    }

    @Override
    public FastCharBuffer append(CharSequence csq, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.get(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharArraySequence(this.buffer, start, end - start);
    }

    @Override
    public String toString() {
        return new String(this.toArray());
    }
}

