/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.hamcrest.Description;

public class IsMinimum<T>
extends TemporalMatcher<T> {
    private static final String SPLIT_ON_UPPERCASE_REGEX = "(?=[A-Z])";
    private final TemporalConverter<T, ? extends TemporalAccessor> converter;
    private final ChronoField field;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsMinimum(TemporalConverter<T, ? extends TemporalAccessor> converter, ChronoField field, Optional<ZoneId> zone, Locale locale) {
        this.converter = converter;
        this.field = field;
        this.locale = locale;
        this.zone = zone;
    }

    public IsMinimum(TemporalConverter<T, ? extends TemporalAccessor> converter, ChronoField field) {
        this(converter, field, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        TemporalAccessor actualTemporal = this.converter.apply(actual, this.zone);
        ValueRange actualRange = this.field.rangeRefinedBy(actualTemporal);
        long actualValue = this.field.getFrom(actualTemporal);
        long expectedValue = actualRange.getMinimum();
        if (expectedValue != actualValue) {
            mismatchDesc.appendText("date has the value " + actualValue + " instead of " + expectedValue);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the minimum value for " + Stream.of(this.field.getDisplayName(this.locale).split(SPLIT_ON_UPPERCASE_REGEX)).map(String::toLowerCase).collect(Collectors.joining(" ")));
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsMinimum<T>(this.converter, this.field, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsMinimum<T>(this.converter, this.field, this.zone, locale);
    }
}

