/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgSvgElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH$J\u0006\u0010\u0010\u001a\u00020\u000eJ\b\u0010\u0011\u001a\u00020\u000eH$J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/FigureSvgRoot;", "", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;)V", "getBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "isContentBuilt", "", "svg", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "getSvg", "()Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgSvgElement;", "buildContent", "", "buildFigureContent", "clearContent", "clearFigureContent", "ensureContentBuilt", "setSvgSize", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
public abstract class FigureSvgRoot {
    @NotNull
    private final DoubleRectangle bounds;
    @NotNull
    private final SvgSvgElement svg;
    private boolean isContentBuilt;

    public FigureSvgRoot(@NotNull DoubleRectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.bounds = bounds;
        this.svg = new SvgSvgElement();
        this.svg.addClass("plt-container");
        this.setSvgSize(this.bounds.getDimension());
    }

    @NotNull
    public final DoubleRectangle getBounds() {
        return this.bounds;
    }

    @NotNull
    public final SvgSvgElement getSvg() {
        return this.svg;
    }

    public final void ensureContentBuilt() {
        if (!this.isContentBuilt) {
            this.buildContent();
        }
    }

    private final void buildContent() {
        if (!(!this.isContentBuilt)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.isContentBuilt = true;
        this.buildFigureContent();
    }

    public final void clearContent() {
        if (this.isContentBuilt) {
            this.isContentBuilt = false;
            this.svg.children().clear();
            this.clearFigureContent();
        }
    }

    protected abstract void buildFigureContent();

    protected abstract void clearFigureContent();

    private final void setSvgSize(DoubleVector size) {
        this.svg.width().set((Object)size.getX());
        this.svg.height().set((Object)size.getY());
    }
}

