/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedTestElementSchema;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.schema.PropertiesAccessor;

public abstract class AbstractScopedTestElement
extends AbstractTestElement {
    private static final long serialVersionUID = 240L;
    private static final String SCOPE = "Sample.scope";
    private static final String SCOPE_PARENT = "parent";
    private static final String SCOPE_CHILDREN = "children";
    private static final String SCOPE_ALL = "all";
    private static final String SCOPE_VARIABLE = "variable";
    private static final String SCOPE_VARIABLE_NAME = "Scope.variable";

    @Override
    public AbstractScopedTestElementSchema getSchema() {
        return AbstractScopedTestElementSchema.INSTANCE;
    }

    public PropertiesAccessor<? extends AbstractScopedTestElement, ? extends AbstractScopedTestElementSchema> getProps() {
        return new PropertiesAccessor<AbstractScopedTestElement, AbstractScopedTestElementSchema>(this, this.getSchema());
    }

    protected String getScopeName() {
        return SCOPE;
    }

    public String fetchScope() {
        return this.getPropertyAsString(this.getScopeName(), SCOPE_PARENT);
    }

    public boolean isScopeParent(String scope) {
        return scope.equals(SCOPE_PARENT);
    }

    public boolean isScopeChildren(String scope) {
        return scope.equals(SCOPE_CHILDREN);
    }

    public boolean isScopeAll(String scope) {
        return scope.equals(SCOPE_ALL);
    }

    public boolean isScopeVariable(String scope) {
        return scope.equals(SCOPE_VARIABLE);
    }

    protected boolean isScopeVariable() {
        return this.isScopeVariable(this.fetchScope());
    }

    public String getVariableName() {
        return this.getPropertyAsString(SCOPE_VARIABLE_NAME, "");
    }

    public void setScopeParent() {
        this.removeProperty(this.getScopeName());
    }

    public void setScopeChildren() {
        this.setProperty(this.getScopeName(), SCOPE_CHILDREN);
    }

    public void setScopeAll() {
        this.setProperty(this.getScopeName(), SCOPE_ALL);
    }

    public void setScopeVariable(String variableName) {
        this.setProperty(this.getScopeName(), SCOPE_VARIABLE);
        this.setProperty(SCOPE_VARIABLE_NAME, variableName);
    }

    protected List<SampleResult> getSampleList(SampleResult result) {
        ArrayList<SampleResult> sampleList = new ArrayList<SampleResult>();
        String scope = this.fetchScope();
        if (this.isScopeParent(scope) || this.isScopeAll(scope)) {
            sampleList.add(result);
        }
        if (this.isScopeChildren(scope) || this.isScopeAll(scope)) {
            AbstractScopedTestElement.recurseResults(sampleList, result);
        }
        return sampleList;
    }

    private static void recurseResults(List<? super SampleResult> resultList, SampleResult sampleResult) {
        Collections.addAll(resultList, sampleResult.getSubResults());
        AbstractScopedTestElement.recurseResults(resultList, sampleResult.getSubResults(), 3);
    }

    private static void recurseResults(List<? super SampleResult> resultList, SampleResult[] sampleResult, int level) {
        if (level < 0) {
            return;
        }
        for (SampleResult child : sampleResult) {
            Collections.addAll(resultList, child.getSubResults());
            AbstractScopedTestElement.recurseResults(resultList, child.getSubResults(), level - 1);
        }
    }
}

