/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel;

import java.util.List;
import java.util.PrimitiveIterator;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.jmeter.threads.openmodel.EvenArrivalsRamp;
import org.apache.jmeter.threads.openmodel.PoissonArrivalsRamp;
import org.apache.jmeter.threads.openmodel.ThreadSchedule;
import org.apache.jmeter.threads.openmodel.ThreadScheduleStep;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\t\u0010\u001a\u001a\u00020\u0019H\u0096\u0002J\b\u0010\u001b\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/apache/jmeter/threads/openmodel/ThreadScheduleProcessGenerator;", "Ljava/util/PrimitiveIterator$OfDouble;", "random", "Ljava/util/Random;", "schedule", "Lorg/apache/jmeter/threads/openmodel/ThreadSchedule;", "(Ljava/util/Random;Lorg/apache/jmeter/threads/openmodel/ThreadSchedule;)V", "arrivalStep", "Lorg/apache/jmeter/threads/openmodel/ThreadScheduleStep$ArrivalsStep;", "beginRate", "", "endRate", "evenRamp", "Lorg/apache/jmeter/threads/openmodel/EvenArrivalsRamp;", "gen", "lastDuration", "poissonRamp", "Lorg/apache/jmeter/threads/openmodel/PoissonArrivalsRamp;", "pos", "", "timeOffset", "totalDuration", "getTotalDuration", "()D", "findNextArrivalStep", "", "hasNext", "nextDouble", "remove", "", "ApacheJMeter_core"})
@SourceDebugExtension(value={"SMAP\nThreadScheduleProcessGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThreadScheduleProcessGenerator.kt\norg/apache/jmeter/threads/openmodel/ThreadScheduleProcessGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class ThreadScheduleProcessGenerator
implements PrimitiveIterator.OfDouble {
    @NotNull
    private final Random random;
    @NotNull
    private final ThreadSchedule schedule;
    private int pos;
    @NotNull
    private final PoissonArrivalsRamp poissonRamp;
    @NotNull
    private final EvenArrivalsRamp evenRamp;
    @NotNull
    private PrimitiveIterator.OfDouble gen;
    private double timeOffset;
    private double lastDuration;
    private double beginRate;
    private double endRate;
    private ThreadScheduleStep.ArrivalsStep arrivalStep;
    private final double totalDuration;

    /*
     * WARNING - void declaration
     */
    public ThreadScheduleProcessGenerator(@NotNull Random random, @NotNull ThreadSchedule schedule) {
        double d;
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        this.random = random;
        this.schedule = schedule;
        this.pos = -1;
        this.poissonRamp = new PoissonArrivalsRamp();
        this.evenRamp = new EvenArrivalsRamp();
        this.gen = this.poissonRamp;
        Iterable iterable = this.schedule.getSteps();
        ThreadScheduleProcessGenerator threadScheduleProcessGenerator = this;
        double d2 = 0.0;
        for (Object t : iterable) {
            void it;
            ThreadScheduleStep threadScheduleStep = (ThreadScheduleStep)t;
            d = d2;
            boolean bl = false;
            ThreadScheduleStep.ArrivalsStep arrivalsStep = it instanceof ThreadScheduleStep.ArrivalsStep ? (ThreadScheduleStep.ArrivalsStep)it : null;
            double d3 = arrivalsStep != null ? arrivalsStep.getDuration() : 0.0;
            d2 = d + d3;
        }
        threadScheduleProcessGenerator.totalDuration = d = d2;
    }

    public final double getTotalDuration() {
        return this.totalDuration;
    }

    @Override
    public void remove() {
        String string = "Element removal is not supported";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public double nextDouble() {
        return this.timeOffset + this.gen.nextDouble();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasNext() {
        if (this.pos != -1 && this.gen.hasNext()) {
            return true;
        }
        do {
            PrimitiveIterator.OfDouble ofDouble;
            this.timeOffset += this.lastDuration;
            this.lastDuration = 0.0;
            if (!this.findNextArrivalStep()) {
                return false;
            }
            ThreadScheduleStep.ArrivalsStep arrivalsStep = this.arrivalStep;
            if (arrivalsStep == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arrivalStep");
                arrivalsStep = null;
            }
            this.lastDuration = arrivalsStep.getDuration();
            ThreadScheduleStep.ArrivalsStep arrivalsStep2 = this.arrivalStep;
            if (arrivalsStep2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"arrivalStep");
                arrivalsStep2 = null;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[arrivalsStep2.getType().ordinal()]) {
                case 1: {
                    PrimitiveIterator.OfDouble $this$hasNext_u24lambda_u241;
                    PrimitiveIterator.OfDouble ofDouble2;
                    PrimitiveIterator.OfDouble ofDouble3 = ofDouble2 = this.evenRamp;
                    ThreadScheduleProcessGenerator threadScheduleProcessGenerator = this;
                    boolean bl = false;
                    ((EvenArrivalsRamp)$this$hasNext_u24lambda_u241).prepare(this.beginRate, this.endRate, this.lastDuration);
                    ThreadScheduleProcessGenerator threadScheduleProcessGenerator2 = threadScheduleProcessGenerator;
                    ofDouble = ofDouble2;
                    break;
                }
                case 2: {
                    void $this$hasNext_u24lambda_u242;
                    ThreadScheduleProcessGenerator threadScheduleProcessGenerator;
                    PrimitiveIterator.OfDouble ofDouble2;
                    PrimitiveIterator.OfDouble $this$hasNext_u24lambda_u241 = ofDouble2 = this.poissonRamp;
                    boolean bl = false;
                    $this$hasNext_u24lambda_u242.prepare(this.beginRate, this.endRate, this.lastDuration, this.random);
                    ThreadScheduleProcessGenerator threadScheduleProcessGenerator2 = threadScheduleProcessGenerator;
                    ofDouble = ofDouble2;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            threadScheduleProcessGenerator2.gen = ofDouble;
        } while (!this.gen.hasNext());
        return true;
    }

    private final boolean findNextArrivalStep() {
        ThreadScheduleStep step;
        List<ThreadScheduleStep> steps = this.schedule.getSteps();
        while (true) {
            ++this.pos;
            if (this.pos == steps.size()) {
                return false;
            }
            step = steps.get(this.pos);
            if (step instanceof ThreadScheduleStep.RateStep) {
                this.beginRate = ((ThreadScheduleStep.RateStep)step).getRate();
                continue;
            }
            if (step instanceof ThreadScheduleStep.ArrivalsStep) break;
        }
        this.arrivalStep = (ThreadScheduleStep.ArrivalsStep)step;
        Object object = CollectionsKt.getOrNull(steps, (int)(this.pos + 1));
        ThreadScheduleStep.RateStep rateStep = object instanceof ThreadScheduleStep.RateStep ? (ThreadScheduleStep.RateStep)object : null;
        this.endRate = rateStep != null ? rateStep.getRate() : this.beginRate;
        return true;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreadScheduleStep.ArrivalType.values().length];
            try {
                nArray[ThreadScheduleStep.ArrivalType.EVEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreadScheduleStep.ArrivalType.RANDOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

