/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import org.apache.jmeter.gui.ClearGui;
import org.apache.jmeter.testbeans.BeanInfoSupport;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.FileEditor;
import org.apache.jmeter.testbeans.gui.TextAreaEditor;
import org.apache.jmeter.util.JSR223TestElement;

public abstract class ScriptingBeanInfoSupport
extends BeanInfoSupport {
    static final String FALSE_AS_STRING = Boolean.FALSE.toString();
    static final String TRUE_AS_STRING = Boolean.TRUE.toString();

    protected ScriptingBeanInfoSupport(Class<? extends TestBean> beanClass, String[] languageTags) {
        this(beanClass, languageTags, null);
    }

    protected ScriptingBeanInfoSupport(Class<? extends TestBean> beanClass, String[] languageTags, ResourceBundle rb) {
        super(beanClass);
        PropertyDescriptor p = this.property("scriptLanguage");
        p.setValue("notUndefined", Boolean.TRUE);
        if (JSR223TestElement.class.isAssignableFrom(beanClass)) {
            p.setValue("default", "groovy");
        } else {
            p.setValue("default", "");
        }
        if (rb != null) {
            p.setValue("resourceBundle", rb);
        }
        p.setValue("tags", languageTags);
        this.createPropertyGroup("scriptingLanguage", new String[]{"scriptLanguage"});
        p = this.property("parameters");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        this.createPropertyGroup("parameterGroup", new String[]{"parameters"});
        p = this.property("filename");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setPropertyEditorClass(FileEditor.class);
        this.createPropertyGroup("filenameGroup", new String[]{"filename"});
        if (JSR223TestElement.class.isAssignableFrom(beanClass)) {
            p = this.property("cacheKey");
            p.setValue("notUndefined", Boolean.TRUE);
            p.setValue("notOther", Boolean.TRUE);
            p.setValue("default", TRUE_AS_STRING);
            p.setPropertyEditorClass(JSR223ScriptCacheCheckboxEditor.class);
            p.setValue("tags", new String[]{TRUE_AS_STRING, FALSE_AS_STRING});
            this.createPropertyGroup("cacheKey_group", new String[]{"cacheKey"});
        }
        p = this.property("script");
        p.setValue("notUndefined", Boolean.TRUE);
        p.setValue("default", "");
        p.setPropertyEditorClass(TextAreaEditor.class);
        this.createPropertyGroup("scripting", new String[]{"script"});
    }

    public static class JSR223ScriptCacheCheckboxEditor
    extends PropertyEditorSupport
    implements ActionListener,
    ClearGui {
        private final JCheckBox checkbox = new JCheckBox();
        private String initialValue = null;

        public JSR223ScriptCacheCheckboxEditor() {
            this.checkbox.addActionListener(this);
        }

        @Override
        public String getAsText() {
            if (this.checkbox.isSelected()) {
                return TRUE_AS_STRING;
            }
            return FALSE_AS_STRING;
        }

        @Override
        public void setAsText(String value) {
            this.initialValue = JSR223ScriptCacheCheckboxEditor.getBooleanValueAsString(value);
            this.checkbox.setSelected(Boolean.parseBoolean(this.initialValue));
        }

        @Override
        public Object getValue() {
            return this.getAsText();
        }

        @Override
        public void setValue(Object value) {
            if (value != null && !(value instanceof String)) {
                throw new IllegalArgumentException();
            }
            this.setAsText(JSR223ScriptCacheCheckboxEditor.getBooleanValueAsString((String)value));
        }

        private static String getBooleanValueAsString(String value) {
            return value == null ? FALSE_AS_STRING : Boolean.toString(!FALSE_AS_STRING.equals(value));
        }

        @Override
        public Component getCustomEditor() {
            return this.checkbox;
        }

        @Override
        public void firePropertyChange() {
            String newValue = this.getAsText();
            if (this.initialValue != null && this.initialValue.equals(newValue)) {
                return;
            }
            this.initialValue = newValue;
            super.firePropertyChange();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.firePropertyChange();
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public void clearGui() {
            this.initialValue = TRUE_AS_STRING;
            this.checkbox.setSelected(true);
        }
    }
}

