/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.spec;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.pos.PositionAdjustments;
import org.jetbrains.letsPlot.core.plot.base.pos.StackablePos;
import org.jetbrains.letsPlot.core.plot.base.pos.StackingMode;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PosProvider;
import org.jetbrains.letsPlot.core.spec.config.ConfigUtil;
import org.jetbrains.letsPlot.core.spec.config.OptionsAccessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0011\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/spec/PosProto;", "", "()V", "DODGE", "", "DODGE_V", "FILL", "IDENTITY", "JITTER", "JITTER_DODGE", "NUDGE", "STACK", "configureFillPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PosProvider;", "options", "Lorg/jetbrains/letsPlot/core/spec/config/OptionsAccessor;", "configureStackPosition", "createPosProvider", "posOptions", "", "plot-stem"})
public final class PosProto {
    @NotNull
    public static final PosProto INSTANCE = new PosProto();
    @NotNull
    public static final String IDENTITY = "identity";
    @NotNull
    public static final String STACK = "stack";
    @NotNull
    public static final String DODGE = "dodge";
    @NotNull
    public static final String DODGE_V = "dodgev";
    @NotNull
    public static final String FILL = "fill";
    @NotNull
    public static final String NUDGE = "nudge";
    @NotNull
    public static final String JITTER = "jitter";
    @NotNull
    public static final String JITTER_DODGE = "jitterdodge";

    private PosProto() {
    }

    @NotNull
    public final PosProvider createPosProvider(@NotNull Map<String, ? extends Object> posOptions) {
        PosProvider posProvider;
        Intrinsics.checkNotNullParameter(posOptions, (String)"posOptions");
        String posName = ConfigUtil.INSTANCE.featureName(posOptions);
        OptionsAccessor opts = new OptionsAccessor(posOptions, null, 2, null);
        switch (posName) {
            case "identity": {
                posProvider = PosProvider.Companion.wrap(PositionAdjustments.INSTANCE.identity());
                break;
            }
            case "stack": {
                posProvider = this.configureStackPosition(opts);
                break;
            }
            case "dodge": {
                posProvider = PosProvider.Companion.dodge(opts.getDouble("width"));
                break;
            }
            case "dodgev": {
                posProvider = PosProvider.Companion.dodgev(opts.getDouble("height"));
                break;
            }
            case "fill": {
                posProvider = this.configureFillPosition(opts);
                break;
            }
            case "jitter": {
                posProvider = PosProvider.Companion.jitter(opts.getDouble("width"), opts.getDouble("height"));
                break;
            }
            case "nudge": {
                posProvider = PosProvider.Companion.nudge(opts.getDouble("x"), opts.getDouble("y"));
                break;
            }
            case "jitterdodge": {
                posProvider = PosProvider.Companion.jitterDodge(opts.getDouble("dodge_width"), opts.getDouble("jitter_width"), opts.getDouble("jitter_height"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown position adjustments name: '" + posName + '\'');
            }
        }
        return posProvider;
    }

    private final PosProvider configureStackPosition(OptionsAccessor options) {
        String string;
        block3: {
            block2: {
                string = options.getString("mode");
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                StackingMode stackingMode = StackingMode.Companion.safeValueOf(it);
                string = stackingMode;
                if (stackingMode != null) break block3;
            }
            string = StackablePos.Companion.getDEF_STACKING_MODE();
        }
        String mode = string;
        return PosProvider.Companion.barStack(options.getDouble("vjust"), (StackingMode)mode);
    }

    private final PosProvider configureFillPosition(OptionsAccessor options) {
        String string;
        block3: {
            block2: {
                string = options.getString("mode");
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                StackingMode stackingMode = StackingMode.Companion.safeValueOf(it);
                string = stackingMode;
                if (stackingMode != null) break block3;
            }
            string = StackablePos.Companion.getDEF_STACKING_MODE();
        }
        String mode = string;
        return PosProvider.Companion.fill(options.getDouble("vjust"), (StackingMode)mode);
    }
}

