/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LazyValue<T> {
    protected Supplier<T> supplier;
    protected T value;

    public LazyValue(T value) {
        this.value = value;
    }

    public LazyValue(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public boolean isInitialized() {
        return this.discardSupplierOnLoad() ? this.supplier == null : this.value != null;
    }

    protected T load() {
        if (this.supplier != null) {
            T obj = this.supplier.get();
            if (this.discardSupplierOnLoad()) {
                this.supplier = null;
            }
            return obj;
        }
        return this.value;
    }

    protected boolean discardSupplierOnLoad() {
        return true;
    }

    protected void set(T value) {
        this.value = value;
    }

    public void ifPresent(Consumer<T> action) {
        if (this.isInitialized() && this.value != null) {
            action.accept(this.value);
        }
    }

    public void ifPresentNullable(Consumer<Optional<T>> action) {
        if (this.isInitialized()) {
            action.accept(Optional.ofNullable(this.value));
        }
    }

    public T get() {
        if (this.value == null) {
            this.set(this.load());
        }
        return this.value;
    }
}

