/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.datetime.tz;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.Duration;
import org.jetbrains.letsPlot.commons.intern.datetime.Instant;
import org.jetbrains.letsPlot.commons.intern.datetime.Month;
import org.jetbrains.letsPlot.commons.intern.datetime.Time;
import org.jetbrains.letsPlot.commons.intern.datetime.WeekDay;
import org.jetbrains.letsPlot.commons.intern.datetime.tz.DateSpec;
import org.jetbrains.letsPlot.commons.intern.datetime.tz.DateSpecs;
import org.jetbrains.letsPlot.commons.intern.datetime.tz.TimeZone;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\tJ\u0016\u0010\u001a\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fJ\u0016\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/tz/TimeZones;", "", "()V", "MILLIS_IN_DAY", "", "MILLIS_IN_HOUR", "MILLIS_IN_MINUTE", "MILLIS_IN_SECOND", "offset", "Lorg/jetbrains/letsPlot/commons/intern/datetime/tz/TimeZone;", "id", "", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "base", "toDateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "instant", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Instant;", "toInstant", "dateTime", "toMillis", "date", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;", "time", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Time;", "utc", "withEuSummerTime", "withUsSummerTime", "DSTimeZone", "commons"})
public final class TimeZones {
    @NotNull
    public static final TimeZones INSTANCE = new TimeZones();
    private static final long MILLIS_IN_SECOND = 1000L;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private static final long MILLIS_IN_HOUR = 3600000L;
    private static final long MILLIS_IN_DAY = 86400000L;

    private TimeZones() {
    }

    private final DateTime toDateTime(Instant instant, Duration offset2) {
        DateTime dateTime;
        Instant instant2 = instant.add(offset2);
        int dayDelta = (int)(instant2.getTimeSinceEpoch() / 86400000L);
        long rest = instant2.getTimeSinceEpoch() % 86400000L;
        int hourDelta = (int)(rest / 3600000L);
        int minuteDelta = (int)((rest %= 3600000L) / 60000L);
        int secondDelta = (int)((rest %= 60000L) / 1000L);
        int millisDelta = (int)((rest %= 1000L) % 1000L);
        if (instant2.getTimeSinceEpoch() >= 0L) {
            Date date = Date.Companion.getEPOCH().addDays(dayDelta);
            dateTime = new DateTime(date, new Time(hourDelta, minuteDelta, secondDelta, millisDelta));
        } else {
            Pair<Integer, Integer> pair2 = TimeZones.toDateTime$subtract(1000, Math.abs(millisDelta));
            int milliseconds = ((Number)pair2.component1()).intValue();
            int secondBorrowing = ((Number)pair2.component2()).intValue();
            Pair<Integer, Integer> pair3 = TimeZones.toDateTime$subtract(60, Math.abs(secondDelta) + secondBorrowing);
            int seconds = ((Number)pair3.component1()).intValue();
            int minuteBorrowing = ((Number)pair3.component2()).intValue();
            Pair<Integer, Integer> pair4 = TimeZones.toDateTime$subtract(60, Math.abs(minuteDelta) + minuteBorrowing);
            int minutes = ((Number)pair4.component1()).intValue();
            int hourBorrowing = ((Number)pair4.component2()).intValue();
            Pair<Integer, Integer> pair5 = TimeZones.toDateTime$subtract(24, Math.abs(hourDelta) + hourBorrowing);
            int hours = ((Number)pair5.component1()).intValue();
            int dayBorrowing = ((Number)pair5.component2()).intValue();
            int days = Math.abs(dayDelta) + dayBorrowing;
            Time time = new Time(hours, minutes, seconds, milliseconds);
            Date date = Date.Companion.getEPOCH().subtractDays(days);
            dateTime = new DateTime(date, time);
        }
        return dateTime;
    }

    private final Instant toInstant(DateTime dateTime, Duration offset2) {
        return new Instant(this.toMillis(dateTime.getDate()) + this.toMillis(dateTime.getTime())).sub(offset2);
    }

    private final long toMillis(Time time) {
        long minutes = (long)time.getHours() * 60L + (long)time.getMinutes();
        long seconds = minutes * (long)60 + (long)time.getSeconds();
        return seconds * (long)1000 + (long)time.getMilliseconds();
    }

    private final long toMillis(Date date) {
        return (long)date.daysFrom(Date.Companion.getEPOCH()) * 86400000L;
    }

    @NotNull
    public final TimeZone utc() {
        return new TimeZone(){

            @NotNull
            public DateTime toDateTime(@NotNull Instant instant) {
                Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
                return TimeZones.access$toDateTime(TimeZones.INSTANCE, instant, new Duration(0L));
            }

            @NotNull
            public Instant toInstant(@NotNull DateTime dateTime) {
                Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
                return TimeZones.access$toInstant(TimeZones.INSTANCE, dateTime, new Duration(0L));
            }
        };
    }

    @NotNull
    public final TimeZone offset(@Nullable String id, @NotNull Duration offset2, @NotNull TimeZone base) {
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        return new TimeZone(id, base, offset2){
            final /* synthetic */ TimeZone $base;
            final /* synthetic */ Duration $offset;
            {
                this.$base = $base;
                this.$offset = $offset;
                super($id);
            }

            @NotNull
            public DateTime toDateTime(@NotNull Instant instant) {
                Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
                return this.$base.toDateTime(instant.add(this.$offset));
            }

            @NotNull
            public Instant toInstant(@NotNull DateTime dateTime) {
                Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
                return this.$base.toInstant(dateTime).sub(this.$offset);
            }
        };
    }

    @NotNull
    public final TimeZone withEuSummerTime(@NotNull String id, @NotNull Duration offset2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        DateSpec startSpec = DateSpecs.INSTANCE.last(WeekDay.SUNDAY, Month.Companion.getMARCH());
        DateSpec endSpec = DateSpecs.INSTANCE.last(WeekDay.SUNDAY, Month.Companion.getOCTOBER());
        Time utcChangeTime = new Time(1, 0, 0, 0, 12, null);
        return new DSTimeZone(id, offset2, startSpec, utcChangeTime, endSpec){
            final /* synthetic */ DateSpec $startSpec;
            final /* synthetic */ Time $utcChangeTime;
            final /* synthetic */ DateSpec $endSpec;
            {
                this.$startSpec = $startSpec;
                this.$utcChangeTime = $utcChangeTime;
                this.$endSpec = $endSpec;
                super($id, $offset);
            }

            @NotNull
            protected Instant getStartInstant(int year) {
                return TimeZone.Companion.getUTC().toInstant(new DateTime(this.$startSpec.getDate(year), this.$utcChangeTime));
            }

            @NotNull
            protected Instant getEndInstant(int year) {
                return TimeZone.Companion.getUTC().toInstant(new DateTime(this.$endSpec.getDate(year), this.$utcChangeTime));
            }
        };
    }

    @NotNull
    public final TimeZone withUsSummerTime(@NotNull String id, @NotNull Duration offset2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        DateSpec startSpec = DateSpecs.INSTANCE.first(WeekDay.SUNDAY, Month.Companion.getMARCH(), 2);
        DateSpec endSpec = DateSpecs.first$default(DateSpecs.INSTANCE, WeekDay.SUNDAY, Month.Companion.getNOVEMBER(), 0, 4, null);
        return new DSTimeZone(id, offset2, startSpec, endSpec){
            final /* synthetic */ Duration $offset;
            final /* synthetic */ DateSpec $startSpec;
            final /* synthetic */ DateSpec $endSpec;
            {
                this.$offset = $offset;
                this.$startSpec = $startSpec;
                this.$endSpec = $endSpec;
                super($id, $offset);
            }

            @NotNull
            protected Instant getStartInstant(int year) {
                return TimeZone.Companion.getUTC().toInstant(new DateTime(this.$startSpec.getDate(year), new Time(2, 0, 0, 0, 12, null))).sub(this.$offset);
            }

            @NotNull
            protected Instant getEndInstant(int year) {
                return TimeZone.Companion.getUTC().toInstant(new DateTime(this.$endSpec.getDate(year), new Time(2, 0, 0, 0, 12, null))).sub(this.$offset.add(Duration.Companion.getHOUR()));
            }
        };
    }

    private static final Pair<Integer, Integer> toDateTime$subtract(int borrowNumber, int subtrahend) {
        return subtrahend == 0 ? TuplesKt.to((Object)0, (Object)0) : TuplesKt.to((Object)(borrowNumber - subtrahend), (Object)1);
    }

    public static final /* synthetic */ DateTime access$toDateTime(TimeZones $this, Instant instant, Duration offset2) {
        return $this.toDateTime(instant, offset2);
    }

    public static final /* synthetic */ Instant access$toInstant(TimeZones $this, DateTime dateTime, Duration offset2) {
        return $this.toInstant(dateTime, offset2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\"\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/tz/TimeZones$DSTimeZone;", "Lorg/jetbrains/letsPlot/commons/intern/datetime/tz/TimeZone;", "id", "", "offset", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;)V", "mySummerTz", "myTz", "getEndInstant", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Instant;", "year", "", "getStartInstant", "toDateTime", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "instant", "toInstant", "dateTime", "commons"})
    private static abstract class DSTimeZone
    extends TimeZone {
        @NotNull
        private final TimeZone myTz;
        @NotNull
        private final TimeZone mySummerTz;

        public DSTimeZone(@NotNull String id, @NotNull Duration offset2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
            super(id);
            this.myTz = INSTANCE.offset(null, offset2, TimeZone.Companion.getUTC());
            this.mySummerTz = INSTANCE.offset(null, offset2.add(Duration.Companion.getHOUR()), TimeZone.Companion.getUTC());
        }

        @Override
        @NotNull
        public DateTime toDateTime(@NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            DateTime tzDt = this.myTz.toDateTime(instant);
            Instant start = this.getStartInstant(tzDt.getYear());
            Instant end = this.getEndInstant(tzDt.getYear());
            return instant.compareTo(start) > 0 && instant.compareTo(end) < 0 ? this.mySummerTz.toDateTime(instant) : tzDt;
        }

        @Override
        @NotNull
        public Instant toInstant(@NotNull DateTime dateTime) {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            DateTime startDt = this.toDateTime(this.getStartInstant(dateTime.getYear()));
            DateTime endDt = this.toDateTime(this.getEndInstant(dateTime.getYear()));
            return dateTime.compareTo(startDt) > 0 && dateTime.compareTo(endDt) < 0 ? this.mySummerTz.toInstant(dateTime) : this.myTz.toInstant(dateTime);
        }

        @NotNull
        protected abstract Instant getStartInstant(int var1);

        @NotNull
        protected abstract Instant getEndInstant(int var1);
    }
}

