/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;

public class HeapDumper {
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final ObjectName hotspotDiagnosticBean;
    private final Exception exception;

    private static HeapDumper getInstance() {
        return DumperHolder.DUMPER;
    }

    private HeapDumper() {
        ObjectName on = null;
        InstanceNotFoundException ex = null;
        try {
            on = new ObjectName(HOTSPOT_BEAN_NAME);
            this.server.getObjectInstance(on);
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)("Could not establish the HotSpotDiagnostic Bean Name: " + e));
        }
        catch (InstanceNotFoundException e) {
            ex = e;
            on = null;
        }
        this.exception = ex;
        this.hotspotDiagnosticBean = on;
    }

    public static void init() throws Exception {
        Exception e = HeapDumper.getInstance().exception;
        if (e != null) {
            throw e;
        }
    }

    public static void dumpHeap(String fileName, boolean live) throws Exception {
        HeapDumper.getInstance().dumpHeap0(fileName, live);
    }

    public static void dumpHeap(String fileName) throws Exception {
        HeapDumper.dumpHeap(fileName, true);
    }

    public static String dumpHeap() throws Exception {
        return HeapDumper.dumpHeap(true);
    }

    public static String dumpHeap(boolean live) throws Exception {
        return HeapDumper.dumpHeap(new File("."), live);
    }

    public static String dumpHeap(File basedir, boolean live) throws Exception {
        DateTimeFormatter timestampFormat = DateTimeFormatter.ofPattern("yyyyMMdd_hhmmss_SSS").withZone(ZoneId.systemDefault());
        String stamp = timestampFormat.format(Instant.now());
        File temp = new File(basedir, "dump_" + stamp + ".hprof");
        String path = temp.getPath();
        HeapDumper.dumpHeap(path, live);
        return path;
    }

    private void dumpHeap0(String fileName, boolean live) throws Exception {
        try {
            if (this.exception != null) {
                throw this.exception;
            }
            this.server.invoke(this.hotspotDiagnosticBean, "dumpHeap", new Object[]{fileName, live}, new String[]{"java.lang.String", "boolean"});
        }
        catch (RuntimeMBeanException e) {
            Throwable f = e.getCause();
            if (f instanceof Exception) {
                throw (Exception)f;
            }
            throw e;
        }
        catch (MBeanException e) {
            Throwable f = e.getCause();
            if (f instanceof Exception) {
                throw (Exception)f;
            }
            throw e;
        }
    }

    private static class DumperHolder {
        private static final HeapDumper DUMPER = new HeapDumper();

        private DumperHolder() {
        }
    }
}

