/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text.bridge;

import com.github.weisj.darklaf.ui.text.DarkTextUI;
import com.github.weisj.darklaf.ui.text.dummy.DummyTextArea;
import com.github.weisj.darklaf.ui.text.dummy.DummyTextAreaUI;
import com.github.weisj.darklaf.util.value.WeakShared;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public abstract class DarkTextAreaUIBridge
extends DarkTextUI {
    private static final WeakShared<JTextArea> sharedArea = new WeakShared(DummyTextArea::new);
    private static final WeakShared<DummyTextAreaUI> sharedBasicTextAreaUI = new WeakShared(DummyTextAreaUI::new);
    private JTextArea textArea;
    private DummyTextAreaUI basicTextAreaUI;

    @Override
    public void installUI(JComponent c) {
        this.textArea = (JTextArea)sharedArea.get();
        this.basicTextAreaUI = (DummyTextAreaUI)sharedBasicTextAreaUI.get();
        super.installUI(c);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.textArea = null;
        this.basicTextAreaUI = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("lineWrap") || evt.getPropertyName().equals("wrapStyleWord") || evt.getPropertyName().equals("tabSize")) {
            this.modelChanged();
        } else if ("editable".equals(evt.getPropertyName())) {
            this.basicTextAreaUI.propertyChange(evt);
        }
    }

    @Override
    public View create(Element elem) {
        JTextComponent editor = this.getComponent();
        if (editor instanceof JTextArea) {
            JTextArea c = (JTextArea)editor;
            this.textArea.setLineWrap(c.getLineWrap());
            this.textArea.setWrapStyleWord(c.getWrapStyleWord());
            this.basicTextAreaUI.installUI(this.textArea);
        }
        return this.basicTextAreaUI.create(elem);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        return this.basicTextAreaUI.getBaseline(c, width, height);
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(JComponent c) {
        return this.basicTextAreaUI.getBaselineResizeBehavior(c);
    }
}

