/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.math3;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.MathArrays;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.PolynomialSplineFunction;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.SplineInterpolator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003H\u0002J(\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/LoessInterpolator;", "", "bandwidth", "", "robustnessIters", "", "accuracy", "(DID)V", "checkAllFiniteReal", "", "values", "", "checkFinite", "x", "interpolate", "Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/PolynomialSplineFunction;", "xval", "yval", "nextNonzero", "weights", "i", "smooth", "tricube", "updateBandwidthInterval", "bandwidthInterval", "", "Companion", "plot-base"})
public final class LoessInterpolator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double bandwidth;
    private final int robustnessIters;
    private final double accuracy;
    public static final double DEFAULT_BANDWIDTH = 0.3;
    public static final int DEFAULT_ROBUSTNESS_ITERS = 2;
    public static final double DEFAULT_ACCURACY = 1.0E-12;

    public LoessInterpolator(double bandwidth, int robustnessIters, double accuracy) {
        this.bandwidth = bandwidth;
        this.robustnessIters = robustnessIters;
        this.accuracy = accuracy;
        if (this.bandwidth <= 0.0 || this.bandwidth > 1.0) {
            throw new IllegalStateException(("Out of range of bandwidth value: " + this.bandwidth + " should be > 0 and <= 1").toString());
        }
        if (this.robustnessIters < 0) {
            throw new IllegalStateException(("Not positive Robutness iterationa: " + this.robustnessIters).toString());
        }
    }

    public /* synthetic */ LoessInterpolator(double d, int n, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            d = 0.3;
        }
        if ((n2 & 2) != 0) {
            n = 2;
        }
        if ((n2 & 4) != 0) {
            d2 = 1.0E-12;
        }
        this(d, n, d2);
    }

    @NotNull
    public final PolynomialSplineFunction interpolate(@NotNull double[] xval, @NotNull double[] yval) {
        Intrinsics.checkNotNullParameter((Object)xval, (String)"xval");
        Intrinsics.checkNotNullParameter((Object)yval, (String)"yval");
        return new SplineInterpolator().interpolate(xval, this.smooth(xval, yval));
    }

    private final double[] smooth(double[] xval, double[] yval, double[] weights) {
        if (xval.length != yval.length) {
            throw new IllegalStateException(("Dimension mismatch of interpolation points: " + xval.length + " != " + yval.length).toString());
        }
        int n = xval.length;
        if (n == 0) {
            throw new IllegalStateException("No data to interpolate".toString());
        }
        this.checkAllFiniteReal(xval);
        this.checkAllFiniteReal(yval);
        this.checkAllFiniteReal(weights);
        MathArrays.INSTANCE.checkOrder(xval);
        if (n == 1) {
            double[] dArray = new double[]{yval[0]};
            return dArray;
        }
        if (n == 2) {
            double[] dArray = new double[]{yval[0], yval[1]};
            return dArray;
        }
        int bandwidthInPoints = (int)(this.bandwidth * (double)n);
        if (bandwidthInPoints < 2) {
            throw new IllegalStateException(("LOESS 'bandwidthInPoints' is too small: " + bandwidthInPoints + " < 2").toString());
        }
        double[] res = new double[n];
        double[] residuals = new double[n];
        double[] sortedResiduals = new double[n];
        double[] robustnessWeights = new double[n];
        ArraysKt.fill$default((double[])robustnessWeights, (double)1.0, (int)0, (int)0, (int)6, null);
        int iter = 0;
        int n2 = this.robustnessIters;
        if (iter <= n2) {
            while (true) {
                int[] nArray = new int[]{0, bandwidthInPoints - 1};
                int[] bandwidthInterval = nArray;
                for (int i = 0; i < n; ++i) {
                    double x = xval[i];
                    if (i > 0) {
                        this.updateBandwidthInterval(xval, weights, i, bandwidthInterval);
                    }
                    int ileft = bandwidthInterval[0];
                    int iright = bandwidthInterval[1];
                    int edge = 0;
                    edge = xval[i] - xval[ileft] > xval[iright] - xval[i] ? ileft : iright;
                    double sumWeights = 0.0;
                    double sumX = 0.0;
                    double sumXSquared = 0.0;
                    double sumY = 0.0;
                    double sumXY = 0.0;
                    double denom = Math.abs(1.0 / (xval[edge] - x));
                    int k = ileft;
                    if (k <= iright) {
                        while (true) {
                            double xk = xval[k];
                            double yk = yval[k];
                            double dist = k < i ? x - xk : xk - x;
                            double w = this.tricube(dist * denom) * robustnessWeights[k] * weights[k];
                            double xkw = xk * w;
                            sumWeights += w;
                            sumX += xkw;
                            sumXSquared += xk * xkw;
                            sumY += yk * w;
                            sumXY += yk * xkw;
                            if (k == iright) break;
                            ++k;
                        }
                    }
                    double meanX = sumX / sumWeights;
                    double meanY = sumY / sumWeights;
                    double meanXY = sumXY / sumWeights;
                    double meanXSquared = sumXSquared / sumWeights;
                    double beta = 0.0;
                    beta = Math.sqrt(Math.abs(meanXSquared - meanX * meanX)) < this.accuracy ? 0.0 : (meanXY - meanX * meanY) / (meanXSquared - meanX * meanX);
                    double alpha = meanY - beta * meanX;
                    res[i] = beta * x + alpha;
                    residuals[i] = Math.abs(yval[i] - res[i]);
                }
                if (iter == this.robustnessIters) break;
                ArraysKt.copyInto((double[])residuals, (double[])sortedResiduals, (int)0, (int)0, (int)n);
                ArraysKt.sort((double[])sortedResiduals);
                double medianResidual = sortedResiduals[n / 2];
                if (Math.abs(medianResidual) < this.accuracy) break;
                for (int i = 0; i < n; ++i) {
                    double arg = residuals[i] / ((double)6 * medianResidual);
                    if (arg >= 1.0) {
                        robustnessWeights[i] = 0.0;
                        continue;
                    }
                    double w = 1.0 - arg * arg;
                    robustnessWeights[i] = w * w;
                }
                if (iter == n2) break;
                ++iter;
            }
        }
        return res;
    }

    private final void updateBandwidthInterval(double[] xval, double[] weights, int i, int[] bandwidthInterval) {
        int left = bandwidthInterval[0];
        int right = bandwidthInterval[1];
        int nextRight = this.nextNonzero(weights, right);
        if (nextRight < xval.length && xval[nextRight] - xval[i] < xval[i] - xval[left]) {
            int nextLeft;
            bandwidthInterval[0] = nextLeft = this.nextNonzero(weights, bandwidthInterval[0]);
            bandwidthInterval[1] = nextRight;
        }
    }

    private final double tricube(double x) {
        double absX = Math.abs(x);
        if (absX >= 1.0) {
            return 0.0;
        }
        double tmp = 1.0 - absX * absX * absX;
        return tmp * tmp * tmp;
    }

    private final int nextNonzero(double[] weights, int i) {
        int j;
        for (j = i + 1; j < weights.length && weights[j] == 0.0; ++j) {
        }
        return j;
    }

    private final double[] smooth(double[] xval, double[] yval) {
        if (xval.length != yval.length) {
            throw new IllegalStateException(("Dimension mismatch: " + xval.length + " != " + yval.length).toString());
        }
        double[] unitWeights = new double[xval.length];
        ArraysKt.fill$default((double[])unitWeights, (double)1.0, (int)0, (int)0, (int)6, null);
        return this.smooth(xval, yval, unitWeights);
    }

    private final void checkFinite(double x) {
        if (Double.isInfinite(x) || Double.isNaN(x)) {
            throw new IllegalStateException(("Argument " + x + " is not a finite number").toString());
        }
    }

    private final void checkAllFiniteReal(double[] values) {
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            this.checkFinite(values[i]);
        }
    }

    public LoessInterpolator() {
        this(0.0, 0, 0.0, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/LoessInterpolator$Companion;", "", "()V", "DEFAULT_ACCURACY", "", "DEFAULT_BANDWIDTH", "DEFAULT_ROBUSTNESS_ITERS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

