/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath;

import io.burt.jmespath.function.FunctionRegistry;

public class RuntimeConfiguration {
    private final FunctionRegistry functionRegistry;
    private final boolean silentTypeErrors;

    private RuntimeConfiguration(Builder builder) {
        this.functionRegistry = builder.functionRegistry;
        this.silentTypeErrors = builder.silentTypeErrors;
    }

    public FunctionRegistry functionRegistry() {
        return this.functionRegistry;
    }

    public boolean silentTypeErrors() {
        return this.silentTypeErrors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RuntimeConfiguration defaultConfiguration() {
        return RuntimeConfiguration.builder().build();
    }

    public static class Builder {
        protected FunctionRegistry functionRegistry = FunctionRegistry.defaultRegistry();
        protected boolean silentTypeErrors;

        public RuntimeConfiguration build() {
            return new RuntimeConfiguration(this);
        }

        public Builder withFunctionRegistry(FunctionRegistry functionRegistry) {
            this.functionRegistry = functionRegistry;
            return this;
        }

        public Builder withSilentTypeErrors(boolean silentTypeErrors) {
            this.silentTypeErrors = silentTypeErrors;
            return this;
        }
    }
}

