/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.internalframe;

import com.github.weisj.darklaf.components.uiresource.JButtonUIResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class DarkDesktopIconUI
extends BasicDesktopIconUI
implements PropertyChangeListener {
    protected JButton button;
    protected JLabel gripLabel;
    protected int width;
    protected int height;
    protected int labelPad;

    public static ComponentUI createUI(JComponent c) {
        return new DarkDesktopIconUI();
    }

    @Override
    protected void installComponents() {
        this.frame = this.desktopIcon.getInternalFrame();
        Icon icon = this.frame.getFrameIcon();
        String title = this.frame.getTitle();
        this.button = new JButtonUIResource(title, icon);
        this.button.setOpaque(false);
        this.button.setFocusable(false);
        this.button.putClientProperty("JButton.variant", "borderlessRectangular");
        this.button.putClientProperty("JButton.borderless.hover", UIManager.getColor("DesktopIcon.hoverColor"));
        this.button.putClientProperty("JButton.borderless.click", UIManager.getColor("DesktopIcon.hoverColor"));
        this.button.setRolloverEnabled(true);
        this.button.addActionListener(e -> this.deiconize());
        this.button.setFont(this.desktopIcon.getFont());
        this.button.setBackground(this.desktopIcon.getBackground());
        this.button.setForeground(this.desktopIcon.getForeground());
        this.labelPad = UIManager.getInt("DesktopIcon.labelPad");
        Icon drag = UIManager.getIcon("DesktopIcon.drag.icon");
        this.gripLabel = new JLabel(drag);
        this.gripLabel.setBorder(new MatteBorder(0, 2, 0, 1, this.desktopIcon.getBackground()));
        this.desktopIcon.setLayout(new BorderLayout(this.labelPad, 0));
        this.desktopIcon.add((Component)this.button, "Center");
        this.desktopIcon.add((Component)this.gripLabel, "East");
    }

    @Override
    protected void uninstallComponents() {
        this.desktopIcon.setLayout(null);
        this.desktopIcon.remove(this.gripLabel);
        this.desktopIcon.remove(this.button);
        this.button = null;
        this.frame = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installColorsAndFont(this.desktopIcon, "DesktopIcon.background", "DesktopIcon.foreground", "DesktopIcon.font");
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("title")) {
            this.button.setText((String)e.getNewValue());
        }
        if (e.getPropertyName().equals("frameIcon")) {
            this.button.setIcon((Icon)e.getNewValue());
        }
    }
}

