/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.datamodel.svg.dom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTransform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00020\n\"\u00020\u000bH\u0002J\u0006\u0010\f\u001a\u00020\rJ6\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bJ\u001e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bJ\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000bJ\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0019R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransformBuilder;", "", "()V", "myStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addTransformation", "name", "", "values", "", "", "build", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTransform;", "matrix", "a", "b", "c", "d", "e", "f", "rotate", "x", "y", "origin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "scale", "skewX", "skewY", "translate", "vector", "datamodel"})
public final class SvgTransformBuilder {
    @NotNull
    private final StringBuilder myStringBuilder = new StringBuilder();

    @NotNull
    public final SvgTransform build() {
        String string = this.myStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new SvgTransform(string);
    }

    private final SvgTransformBuilder addTransformation(String name, double ... values2) {
        this.myStringBuilder.append(name).append('(');
        for (double val : values2) {
            this.myStringBuilder.append(val).append(' ');
        }
        this.myStringBuilder.append(") ");
        return this;
    }

    @NotNull
    public final SvgTransformBuilder matrix(double a, double b, double c, double d, double e, double f) {
        double[] dArray = new double[]{a, b, c, d, e, f};
        return this.addTransformation("matrix", dArray);
    }

    @NotNull
    public final SvgTransformBuilder translate(double x, double y) {
        double[] dArray = new double[]{x, y};
        return this.addTransformation("translate", dArray);
    }

    @NotNull
    public final SvgTransformBuilder translate(@NotNull DoubleVector vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        return this.translate(vector.getX(), vector.getY());
    }

    @NotNull
    public final SvgTransformBuilder translate(double x) {
        double[] dArray = new double[]{x};
        return this.addTransformation("translate", dArray);
    }

    @NotNull
    public final SvgTransformBuilder scale(double x, double y) {
        double[] dArray = new double[]{x, y};
        return this.addTransformation("scale", dArray);
    }

    @NotNull
    public final SvgTransformBuilder scale(double x) {
        double[] dArray = new double[]{x};
        return this.addTransformation("scale", dArray);
    }

    @NotNull
    public final SvgTransformBuilder rotate(double a, double x, double y) {
        double[] dArray = new double[]{a, x, y};
        return this.addTransformation("rotate", dArray);
    }

    @NotNull
    public final SvgTransformBuilder rotate(double a, @NotNull DoubleVector origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        return this.rotate(a, origin.getX(), origin.getY());
    }

    @NotNull
    public final SvgTransformBuilder rotate(double a) {
        double[] dArray = new double[]{a};
        return this.addTransformation("rotate", dArray);
    }

    @NotNull
    public final SvgTransformBuilder skewX(double a) {
        double[] dArray = new double[]{a};
        return this.addTransformation("skewX", dArray);
    }

    @NotNull
    public final SvgTransformBuilder skewY(double a) {
        double[] dArray = new double[]{a};
        return this.addTransformation("skewY", dArray);
    }
}

