/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.colorspace;

import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.colorspace.HSL;
import org.jetbrains.letsPlot.commons.values.Color;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"hslFromRgb", "Lorg/jetbrains/letsPlot/commons/colorspace/HSL;", "rgb", "Lorg/jetbrains/letsPlot/commons/values/Color;", "rgbFromHsl", "hsl", "alpha", "", "commons"})
public final class HSLKt {
    @NotNull
    public static final HSL hslFromRgb(@NotNull Color rgb) {
        double d;
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        double r = (double)rgb.getRed() / 255.0;
        double g = (double)rgb.getGreen() / 255.0;
        double b = (double)rgb.getBlue() / 255.0;
        double max = Math.max(r, Math.max(g, b));
        double min = Math.min(r, Math.min(g, b));
        double delta = max - min;
        double l = (max + min) / 2.0;
        double s = delta == 0.0 ? 0.0 : delta / (1.0 - Math.abs(2.0 * l - 1.0));
        if (delta == 0.0) {
            d = 0.0;
        } else {
            double d2 = max;
            if (d2 == r) {
                d = (g - b) / (max - min) % (double)6;
            } else if (d2 == g) {
                d = (b - r) / (max - min) + (double)2;
            } else if (d2 == b) {
                d = (r - g) / (max - min) + (double)4;
            } else {
                throw new IllegalStateException(("max value (" + max + ") does not match any of r(" + r + "), g(" + g + "), b(" + b + ')').toString());
            }
        }
        double h = d * 60.0;
        return new HSL(h >= 0.0 ? h : h + 360.0, s, l);
    }

    @NotNull
    public static final Color rgbFromHsl(@NotNull HSL hsl, double alpha) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)hsl, (String)"hsl");
        double c = (1.0 - Math.abs((double)2 * hsl.getL() - 1.0)) * hsl.getS();
        double h2 = hsl.getH() / (double)60;
        double x2 = c * (1.0 - Math.abs(h2 % (double)2 - 1.0));
        double d = h2;
        boolean bl = 0.0 <= d ? d <= 1.0 : false;
        if (bl) {
            triple = new Triple((Object)c, (Object)x2, (Object)0.0);
        } else {
            boolean bl2 = 1.0 <= d ? d <= 2.0 : false;
            if (bl2) {
                triple = new Triple((Object)x2, (Object)c, (Object)0.0);
            } else {
                boolean bl3 = 2.0 <= d ? d <= 3.0 : false;
                if (bl3) {
                    triple = new Triple((Object)0.0, (Object)c, (Object)x2);
                } else {
                    boolean bl4 = 3.0 <= d ? d <= 4.0 : false;
                    if (bl4) {
                        triple = new Triple((Object)0.0, (Object)x2, (Object)c);
                    } else {
                        boolean bl5 = 4.0 <= d ? d <= 5.0 : false;
                        if (bl5) {
                            triple = new Triple((Object)x2, (Object)0.0, (Object)c);
                        } else {
                            boolean bl6 = 5.0 <= d ? d <= 6.0 : false;
                            if (bl6) {
                                triple = new Triple((Object)c, (Object)0.0, (Object)x2);
                            } else {
                                throw new IllegalStateException(("Unexpected h2 value: " + h2).toString());
                            }
                        }
                    }
                }
            }
        }
        Triple triple2 = triple;
        double r1 = ((Number)triple2.component1()).doubleValue();
        double g1 = ((Number)triple2.component2()).doubleValue();
        double b1 = ((Number)triple2.component3()).doubleValue();
        double m = hsl.getL() - c / 2.0;
        return new Color(MathKt.roundToInt((double)((r1 + m) * (double)255)), MathKt.roundToInt((double)((g1 + m) * (double)255)), MathKt.roundToInt((double)((b1 + m) * (double)255)), MathKt.roundToInt((double)255.0)).changeAlpha(MathKt.roundToInt((double)((double)255 * alpha)));
    }

    public static /* synthetic */ Color rgbFromHsl$default(HSL hSL, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = 1.0;
        }
        return HSLKt.rgbFromHsl(hSL, d);
    }
}

