/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.debug;

import java.util.Map;
import org.apache.juneau.Enablement;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.DefaultSettingsMap;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.rest.ResourceSupplier;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.annotation.RestOpAnnotation;
import org.apache.juneau.rest.debug.DebugEnablement;
import org.apache.juneau.svl.VarResolver;

public class BasicDebugEnablement
extends DebugEnablement {
    public BasicDebugEnablement(BeanStore beanStore) {
        super(beanStore);
    }

    @Override
    protected DebugEnablement.Builder init(BeanStore beanStore) {
        DebugEnablement.Builder b = super.init(beanStore);
        DefaultSettingsMap defaultSettings = beanStore.getBean(DefaultSettingsMap.class).get();
        RestContext.Builder builder = beanStore.getBean(RestContext.Builder.class).get();
        ResourceSupplier resource = beanStore.getBean(ResourceSupplier.class).get();
        VarResolver varResolver = beanStore.getBean(VarResolver.class).get();
        Enablement debugDefault = defaultSettings.get(Enablement.class, "RestContext.debugDefault").orElse(builder.isDebug() ? Enablement.ALWAYS : Enablement.NEVER);
        b.defaultEnable(debugDefault);
        ClassInfo ci = ClassInfo.ofProxy(resource.get());
        ci.forEachAnnotation(Rest.class, x -> true, x -> {
            String x2 = varResolver.resolve(x.debug());
            if (!x2.isEmpty()) {
                b.enable(Enablement.fromString(x2), ci.getFullName());
            }
        });
        ci.forEachPublicMethod(x -> true, x -> x.getAnnotationList(RestOpAnnotation.REST_OP_GROUP).forEachValue(String.class, "debug", y -> true, y -> {
            String y2 = varResolver.resolve((String)y);
            if (!y2.isEmpty()) {
                b.enable(Enablement.fromString(y2), x.getFullName());
            }
        }));
        ci.forEachAnnotation(Rest.class, x -> true, x -> {
            String x2 = varResolver.resolve(x.debugOn());
            for (Map.Entry<String, String> e : StringUtils.splitMap(x2, true).entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (v.isEmpty()) {
                    v = "ALWAYS";
                }
                if (k.isEmpty()) continue;
                b.enable(Enablement.fromString(v), k);
            }
        });
        return b;
    }
}

