/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.juneau.BeanBuilder;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.cp.BasicFileFinder;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.LocalDir;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;

public interface FileFinder {
    public static Builder create(BeanStore beanStore) {
        return new Builder(beanStore);
    }

    public static Builder create() {
        return new Builder(BeanStore.INSTANCE);
    }

    public Optional<InputStream> getStream(String var1, Locale var2) throws IOException;

    public Optional<String> getString(String var1, Locale var2) throws IOException;

    @FluentSetters
    public static class Builder
    extends BeanBuilder<FileFinder> {
        final Set<LocalDir> roots = CollectionUtils.set(new LocalDir[0]);
        long cachingLimit = -1L;
        Pattern[] include = new Pattern[]{Pattern.compile(".*")};
        Pattern[] exclude = new Pattern[0];

        protected Builder(BeanStore beanStore) {
            super(BasicFileFinder.class, beanStore);
        }

        @Override
        protected FileFinder buildDefault() {
            return new BasicFileFinder(this);
        }

        @FluentSetter
        public Builder cp(Class<?> c, String path, boolean recursive) {
            ArgUtils.assertArgNotNull((String)"c", c);
            while (c != null) {
                this.roots.add(new LocalDir(c, path));
                c = recursive ? c.getSuperclass() : null;
            }
            return this;
        }

        @FluentSetter
        public Builder dir(String path) {
            ArgUtils.assertArgNotNull((String)"path", (Object)path);
            return this.path(Paths.get(".", new String[0]).resolve(path));
        }

        @FluentSetter
        public Builder path(Path path) {
            this.roots.add(new LocalDir(path));
            return this;
        }

        @FluentSetter
        public Builder caching(long cachingLimit) {
            this.cachingLimit = cachingLimit;
            return this;
        }

        @FluentSetter
        public Builder include(String ... patterns) {
            this.include = (Pattern[])CollectionUtils.alist(patterns).stream().map(Pattern::compile).toArray(Pattern[]::new);
            return this;
        }

        @FluentSetter
        public Builder exclude(String ... patterns) {
            this.exclude = (Pattern[])CollectionUtils.alist(patterns).stream().map(Pattern::compile).toArray(Pattern[]::new);
            return this;
        }

        public Builder impl(Object value) {
            super.impl(value);
            return this;
        }

        public Builder type(Class<?> value) {
            super.type(value);
            return this;
        }
    }

    public static abstract class Void
    implements FileFinder {
    }
}

