/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.runtime.TransformationStage;
import org.apache.kafka.connect.runtime.errors.RetryWithToleranceOperator;
import org.apache.kafka.connect.runtime.errors.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformationChain<R extends ConnectRecord<R>>
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TransformationChain.class);
    private final List<TransformationStage<R>> transformationStages;
    private final RetryWithToleranceOperator retryWithToleranceOperator;

    public TransformationChain(List<TransformationStage<R>> transformationStages, RetryWithToleranceOperator retryWithToleranceOperator) {
        this.transformationStages = transformationStages;
        this.retryWithToleranceOperator = retryWithToleranceOperator;
    }

    public R apply(R record) {
        if (this.transformationStages.isEmpty()) {
            return record;
        }
        for (TransformationStage transformationStage : this.transformationStages) {
            Object current = record;
            log.trace("Applying transformation {} to {}", (Object)transformationStage.transformClass().getName(), record);
            record = (ConnectRecord)this.retryWithToleranceOperator.execute(() -> transformationStage.apply(current), Stage.TRANSFORMATION, transformationStage.transformClass());
            if (record != null) continue;
            break;
        }
        return record;
    }

    @Override
    public void close() {
        for (TransformationStage<R> transformationStage : this.transformationStages) {
            transformationStage.close();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformationChain that = (TransformationChain)o;
        return Objects.equals(this.transformationStages, that.transformationStages);
    }

    public int hashCode() {
        return Objects.hash(this.transformationStages);
    }

    public String toString() {
        StringJoiner chain = new StringJoiner(", ", this.getClass().getName() + "{", "}");
        for (TransformationStage<R> transformationStage : this.transformationStages) {
            chain.add(transformationStage.transformClass().getName());
        }
        return chain.toString();
    }
}

