/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Map;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;

public final class ProcessorContextUtils {
    private ProcessorContextUtils() {
    }

    public static StreamsMetricsImpl getMetricsImpl(ProcessorContext context) {
        return (StreamsMetricsImpl)context.metrics();
    }

    public static StreamsMetricsImpl getMetricsImpl(StateStoreContext context) {
        return (StreamsMetricsImpl)context.metrics();
    }

    public static String changelogFor(ProcessorContext context, String storeName, Boolean newChangelogTopic) {
        String changelogTopic;
        String prefix = ProcessorContextUtils.getPrefix(context.appConfigs(), context.applicationId());
        if (context instanceof InternalProcessorContext && !newChangelogTopic.booleanValue() && (changelogTopic = ((InternalProcessorContext)context).changelogFor(storeName)) != null) {
            return changelogTopic;
        }
        return ProcessorStateManager.storeChangelogTopic(prefix, storeName, context.taskId().topologyName());
    }

    public static String changelogFor(StateStoreContext context, String storeName, Boolean newChangelogTopic) {
        String changelogTopic;
        String prefix = ProcessorContextUtils.getPrefix(context.appConfigs(), context.applicationId());
        if (context instanceof InternalProcessorContext && !newChangelogTopic.booleanValue() && (changelogTopic = ((InternalProcessorContext)context).changelogFor(storeName)) != null) {
            return changelogTopic;
        }
        return ProcessorStateManager.storeChangelogTopic(prefix, storeName, context.taskId().topologyName());
    }

    public static String getPrefix(Map<String, Object> configs, String applicationId) {
        if (configs == null) {
            return applicationId;
        }
        return StreamsConfig.InternalConfig.getString(configs, "__internal.override.topic.prefix__", applicationId);
    }

    public static InternalProcessorContext asInternalProcessorContext(ProcessorContext context) {
        if (context instanceof InternalProcessorContext) {
            return (InternalProcessorContext)context;
        }
        throw new IllegalArgumentException("This component requires internal features of Kafka Streams and must be disabled for unit tests.");
    }

    public static InternalProcessorContext asInternalProcessorContext(StateStoreContext context) {
        if (context instanceof InternalProcessorContext) {
            return (InternalProcessorContext)context;
        }
        throw new IllegalArgumentException("This component requires internal features of Kafka Streams and must be disabled for unit tests.");
    }
}

