/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.cli;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.runtime.Connect;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerInfo;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.ConnectRestServer;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectCli<T extends WorkerConfig> {
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectCli.class);
    private final String[] args;
    private final Time time = Time.SYSTEM;

    protected AbstractConnectCli(String ... args) {
        this.args = args;
    }

    protected abstract String usage();

    protected void processExtraArgs(Herder herder, Connect connect, String[] extraArgs) {
    }

    protected abstract Herder createHerder(T var1, String var2, Plugins var3, ConnectorClientConfigOverridePolicy var4, RestServer var5, RestClient var6);

    protected abstract T createConfig(Map<String, String> var1);

    public void run() {
        if (this.args.length < 1 || Arrays.asList(this.args).contains("--help")) {
            log.info("Usage: {}", (Object)this.usage());
            Exit.exit((int)1);
        }
        try {
            String workerPropsFile = this.args[0];
            Map workerProps = !workerPropsFile.isEmpty() ? Utils.propsToStringMap((Properties)Utils.loadProps((String)workerPropsFile)) : Collections.emptyMap();
            String[] extraArgs = Arrays.copyOfRange(this.args, 1, this.args.length);
            Connect connect = this.startConnect(workerProps, extraArgs);
            connect.awaitStop();
        }
        catch (Throwable t) {
            log.error("Stopping due to error", t);
            Exit.exit((int)2);
        }
    }

    public Connect startConnect(Map<String, String> workerProps, String ... extraArgs) {
        log.info("Kafka Connect worker initializing ...");
        long initStart = this.time.hiResClockMs();
        WorkerInfo initInfo = new WorkerInfo();
        initInfo.logAll();
        log.info("Scanning for plugin classes. This might take a moment ...");
        Plugins plugins = new Plugins(workerProps);
        plugins.compareAndSwapWithDelegatingLoader();
        T config = this.createConfig(workerProps);
        log.debug("Kafka cluster ID: {}", (Object)((WorkerConfig)((Object)config)).kafkaClusterId());
        RestClient restClient = new RestClient((AbstractConfig)config);
        ConnectRestServer restServer = new ConnectRestServer(((WorkerConfig)((Object)config)).rebalanceTimeout(), restClient, ((WorkerConfig)((Object)config)).originals());
        restServer.initializeServer();
        URI advertisedUrl = restServer.advertisedUrl();
        String workerId = advertisedUrl.getHost() + ":" + advertisedUrl.getPort();
        ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy = plugins.newPlugin(config.getString("connector.client.config.override.policy"), (AbstractConfig)config, ConnectorClientConfigOverridePolicy.class);
        Herder herder = this.createHerder(config, workerId, plugins, connectorClientConfigOverridePolicy, restServer, restClient);
        Connect connect = new Connect(herder, restServer);
        log.info("Kafka Connect worker initialization took {}ms", (Object)(this.time.hiResClockMs() - initStart));
        try {
            connect.start();
        }
        catch (Exception e) {
            log.error("Failed to start Connect", (Throwable)e);
            connect.stop();
            Exit.exit((int)3);
        }
        this.processExtraArgs(herder, connect, extraArgs);
        return connect;
    }
}

