/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.raft.DynamicVoter;
import org.apache.kafka.raft.VoterSet;

public final class DynamicVoters {
    private final NavigableMap<Integer, DynamicVoter> voters;

    public static DynamicVoters parse(String input) {
        input = input.trim();
        ArrayList<DynamicVoter> voters = new ArrayList<DynamicVoter>();
        for (String voterString : input.split(",")) {
            if (voterString.isEmpty()) continue;
            voters.add(DynamicVoter.parse(voterString));
        }
        return new DynamicVoters(voters);
    }

    public DynamicVoters(Collection<DynamicVoter> voters) {
        if (voters.isEmpty()) {
            throw new IllegalArgumentException("No voters given.");
        }
        TreeMap<Integer, DynamicVoter> votersMap = new TreeMap<Integer, DynamicVoter>();
        for (DynamicVoter voter : voters) {
            if (votersMap.put(voter.nodeId(), voter) == null) continue;
            throw new IllegalArgumentException("Node id " + voter.nodeId() + " was specified more than once.");
        }
        this.voters = Collections.unmodifiableNavigableMap(votersMap);
    }

    public NavigableMap<Integer, DynamicVoter> voters() {
        return this.voters;
    }

    public VoterSet toVoterSet(String controllerListenerName) {
        HashMap<Integer, VoterSet.VoterNode> voterSetMap = new HashMap<Integer, VoterSet.VoterNode>();
        for (DynamicVoter voter : this.voters.values()) {
            voterSetMap.put(voter.nodeId(), voter.toVoterNode(controllerListenerName));
        }
        return VoterSet.fromMap(voterSetMap);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(DynamicVoters.class)) {
            return false;
        }
        DynamicVoters other = (DynamicVoters)o;
        return this.voters.equals(other.voters);
    }

    public int hashCode() {
        return this.voters.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        for (DynamicVoter voter : this.voters.values()) {
            builder.append(prefix);
            prefix = ",";
            builder.append(voter.toString());
        }
        return builder.toString();
    }
}

