/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;

public class BootstrapMetadata {
    private final List<ApiMessageAndVersion> records;
    private final short metadataVersionLevel;
    private final String source;

    public static BootstrapMetadata fromVersions(MetadataVersion metadataVersion, Map<String, Short> featureVersions, String source) {
        ArrayList<ApiMessageAndVersion> records = new ArrayList<ApiMessageAndVersion>();
        records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()), 0));
        ArrayList featureNames = new ArrayList(featureVersions.size());
        featureVersions.keySet().forEach(n -> {
            if (!n.equals("metadata.version") && !n.equals("kraft.version")) {
                featureNames.add(n);
            }
        });
        featureNames.sort(String::compareTo);
        for (String featureName : featureNames) {
            short level = featureVersions.get(featureName);
            if (level <= 0) continue;
            records.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName(featureName).setFeatureLevel(level), 0));
        }
        return new BootstrapMetadata(records, metadataVersion.featureLevel(), source);
    }

    public static BootstrapMetadata fromVersion(MetadataVersion metadataVersion, String source) {
        List<ApiMessageAndVersion> records = Collections.singletonList(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(metadataVersion.featureLevel()), 0));
        return new BootstrapMetadata(records, metadataVersion.featureLevel(), source);
    }

    public static BootstrapMetadata fromRecords(List<ApiMessageAndVersion> records, String source) {
        Optional<Object> metadataVersionLevel = Optional.empty();
        for (ApiMessageAndVersion record : records) {
            Optional<Short> level = BootstrapMetadata.recordToMetadataVersionLevel(record.message());
            if (!level.isPresent()) continue;
            metadataVersionLevel = level;
        }
        if (metadataVersionLevel.isEmpty()) {
            throw new RuntimeException("No FeatureLevelRecord for metadata.version was found in the bootstrap metadata from " + source);
        }
        return new BootstrapMetadata(records, (Short)metadataVersionLevel.get(), source);
    }

    public static Optional<Short> recordToMetadataVersionLevel(ApiMessage record) {
        FeatureLevelRecord featureLevel;
        if (record instanceof FeatureLevelRecord && (featureLevel = (FeatureLevelRecord)record).name().equals("metadata.version")) {
            return Optional.of(featureLevel.featureLevel());
        }
        return Optional.empty();
    }

    BootstrapMetadata(List<ApiMessageAndVersion> records, short metadataVersionLevel, String source) {
        this.records = Objects.requireNonNull(records);
        this.metadataVersionLevel = metadataVersionLevel;
        Objects.requireNonNull(source);
        this.source = source;
    }

    public List<ApiMessageAndVersion> records() {
        return this.records;
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.fromFeatureLevel((short)this.metadataVersionLevel);
    }

    public String source() {
        return this.source;
    }

    public short featureLevel(String featureName) {
        short result = 0;
        for (ApiMessageAndVersion record : this.records) {
            FeatureLevelRecord message;
            if (!(record.message() instanceof FeatureLevelRecord) || !(message = (FeatureLevelRecord)record.message()).name().equals(featureName)) continue;
            result = message.featureLevel();
        }
        return result;
    }

    public BootstrapMetadata copyWithFeatureRecord(String featureName, short level) {
        int i;
        ArrayList<ApiMessageAndVersion> newRecords = new ArrayList<ApiMessageAndVersion>();
        for (i = 0; i < this.records.size(); ++i) {
            if (!(this.records.get(i).message() instanceof FeatureLevelRecord)) continue;
            FeatureLevelRecord record = (FeatureLevelRecord)this.records.get(i).message();
            if (record.name().equals(featureName)) {
                FeatureLevelRecord newRecord = record.duplicate();
                newRecord.setFeatureLevel(level);
                newRecords.add(new ApiMessageAndVersion((ApiMessage)newRecord, 0));
                break;
            }
            newRecords.add(this.records.get(i));
        }
        if (i == this.records.size()) {
            FeatureLevelRecord newRecord = new FeatureLevelRecord().setName(featureName).setFeatureLevel(level);
            newRecords.add(new ApiMessageAndVersion((ApiMessage)newRecord, 0));
        }
        return BootstrapMetadata.fromRecords(newRecords, this.source);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.metadataVersionLevel, this.source);
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        BootstrapMetadata other = (BootstrapMetadata)o;
        return Objects.equals(this.records, other.records) && this.metadataVersionLevel == other.metadataVersionLevel && this.source.equals(other.source);
    }

    public String toString() {
        return "BootstrapMetadata(records=" + this.records.toString() + ", metadataVersionLevel=" + this.metadataVersionLevel + ", source=" + this.source + ")";
    }
}

