/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import kafka.coordinator.transaction.BaseKey;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionState$;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.coordinator.transaction.UnknownKey;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogKey;
import org.apache.kafka.coordinator.transaction.generated.TransactionLogValue;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.TransactionVersion;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;

public final class TransactionLog$ {
    public static final TransactionLog$ MODULE$ = new TransactionLog$();
    private static final Compression EnforcedCompression = Compression.NONE;
    private static final short EnforcedRequiredAcks = (short)-1;

    public Compression EnforcedCompression() {
        return EnforcedCompression;
    }

    public short EnforcedRequiredAcks() {
        return EnforcedRequiredAcks;
    }

    public byte[] keyToBytes(String transactionalId) {
        return MessageUtil.toVersionPrefixedBytes((short)0, (Message)new TransactionLogKey().setTransactionalId(transactionalId));
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata, TransactionVersion transactionVersionLevel) {
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (transactionState != null && transactionState.equals(empty$) && txnMetadata.topicPartitions().nonEmpty()) {
            throw new IllegalStateException("Transaction is not expected to have any partitions since its state is " + txnMetadata.txnState() + ": " + txnMetadata);
        }
        TransactionState transactionState2 = txnMetadata.txnState();
        Empty$ empty$2 = Empty$.MODULE$;
        List transactionPartitions = transactionState2 != null && transactionState2.equals(empty$2) ? null : CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)txnMetadata.topicPartitions().groupBy((Function1 & Serializable)x$1 -> x$1.topic()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)x0$1._2();
                return new TransactionLogValue.PartitionsSchema().setTopic(topic).setPartitionIds(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)partitions.map((Function1 & Serializable)tp -> tp.partition())).toList()).asJava());
            }
            throw new MatchError(null);
        })).toList()).asJava();
        return MessageUtil.toVersionPrefixedBytes((short)transactionVersionLevel.transactionLogValueVersion(), (Message)new TransactionLogValue().setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStatus(txnMetadata.txnState().id()).setTransactionLastUpdateTimestampMs(txnMetadata.txnLastUpdateTimestamp()).setTransactionStartTimestampMs(txnMetadata.txnStartTimestamp()).setTransactionPartitions(transactionPartitions).setClientTransactionVersion(txnMetadata.clientTransactionVersion().featureLevel()));
    }

    public BaseKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version >= 0 && version <= 0) {
            TransactionLogKey value = new TransactionLogKey((Readable)new ByteBufferAccessor(buffer), version);
            return new TxnKey(version, value.transactionalId());
        }
        return new UnknownKey(version);
    }

    public Option<TransactionMetadata> readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        if (buffer == null) {
            return None$.MODULE$;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 1) {
            TransactionLogValue value = new TransactionLogValue((Readable)new ByteBufferAccessor(buffer), version);
            short fromFeatureLevel_version = value.clientTransactionVersion();
            TransactionMetadata transactionMetadata = new TransactionMetadata(transactionalId, value.producerId(), value.previousProducerId(), value.nextProducerId(), value.producerEpoch(), -1, value.transactionTimeoutMs(), TransactionState$.MODULE$.fromId(value.transactionStatus()), (scala.collection.mutable.Set<TopicPartition>)((scala.collection.mutable.Set)Set$.MODULE$.empty()), value.transactionStartTimestampMs(), value.transactionLastUpdateTimestampMs(), (TransactionVersion)Feature.TRANSACTION_VERSION.fromFeatureLevel(fromFeatureLevel_version, true));
            if (!transactionMetadata.state().equals(Empty$.MODULE$)) {
                value.transactionPartitions().forEach(partitionsSchema -> transactionMetadata.addPartitions((Set<TopicPartition>)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(partitionsSchema.partitionIds()).asScala().map((Function1 & Serializable)partitionId -> new TopicPartition(partitionsSchema.topic(), Predef$.MODULE$.Integer2int(partitionId)))).toSet()));
            }
            return new Some((Object)transactionMetadata);
        }
        throw new IllegalStateException("Unknown version " + version + " from the transaction log message value");
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        BaseKey baseKey = this.readTxnRecordKey(record.key());
        if (baseKey instanceof TxnKey) {
            Object object;
            TxnKey txnKey = (TxnKey)baseKey;
            String keyString = "transaction_metadata::transactionalId=" + txnKey.transactionalId();
            Option<TransactionMetadata> option = this.readTxnRecordValue(txnKey.transactionalId(), record.value());
            if (None$.MODULE$.equals(option)) {
                object = "<DELETE>";
            } else if (option instanceof Some) {
                TransactionMetadata txnMetadata = (TransactionMetadata)((Some)option).value();
                object = "producerId:" + txnMetadata.producerId() + ",producerEpoch:" + txnMetadata.producerEpoch() + ",state=" + txnMetadata.state() + ",partitions=" + txnMetadata.topicPartitions().mkString("[", ",", "]") + ",txnLastUpdateTimestamp=" + txnMetadata.txnLastUpdateTimestamp() + ",txnTimeoutMs=" + txnMetadata.txnTimeoutMs();
            } else {
                throw new MatchError(option);
            }
            String valueString = object;
            return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
        }
        if (baseKey instanceof UnknownKey) {
            UnknownKey unknownKey = (UnknownKey)baseKey;
            return new Tuple2((Object)new Some((Object)("unknown::version=" + unknownKey.version())), (Object)None$.MODULE$);
        }
        throw new MatchError((Object)baseKey);
    }

    private TransactionLog$() {
    }
}

