/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Optional;
import kafka.server.DelayedRemoteListOffsetsMetrics$;
import kafka.server.ListOffsetsPartitionStatus;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.server.purgatory.DelayedOperation;
import org.apache.kafka.storage.internals.log.OffsetResultHolder;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]a\u0001B\u0006\r\u0001EA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!1\u0005A!A!\u0002\u00139\u0005\"\u00027\u0001\t\u0003i\u0007\"\u0002;\u0001\t\u0003*\b\"\u0002<\u0001\t\u0003*\b\"B<\u0001\t\u0003B\b\"\u0002?\u0001\t\u0013i(\u0001\u0007#fY\u0006LX\r\u001a*f[>$X\rT5ti>3gm]3ug*\u0011QBD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001%y\u0001\"a\u0005\u000f\u000e\u0003QQ!!\u0006\f\u0002\u0013A,(oZ1u_JL(BA\u0007\u0018\u0015\ty\u0001D\u0003\u0002\u001a5\u00051\u0011\r]1dQ\u0016T\u0011aG\u0001\u0004_J<\u0017BA\u000f\u0015\u0005A!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000e\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u001d\u0005)Q\u000f^5mg&\u00111\u0005\t\u0002\b\u0019><w-\u001b8h\u0003\u001d!W\r\\1z\u001bN\u0004\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012A\u0001T8oO\u00069a/\u001a:tS>t\u0007C\u0001\u0014.\u0013\tqsEA\u0002J]R\f\u0011c\u001d;biV\u001c()\u001f)beRLG/[8o!\u0011\td\u0007\u000f \u000e\u0003IR!a\r\u001b\u0002\u000f5,H/\u00192mK*\u0011QgJ\u0001\u000bG>dG.Z2uS>t\u0017BA\u001c3\u0005\ri\u0015\r\u001d\t\u0003sqj\u0011A\u000f\u0006\u0003w]\taaY8n[>t\u0017BA\u001f;\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"a\u0010!\u000e\u00031I!!\u0011\u0007\u000351K7\u000f^(gMN,Go\u001d)beRLG/[8o'R\fG/^:\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011q\bR\u0005\u0003\u000b2\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/\u0001\tsKN\u0004xN\\:f\u0007\u0006dGNY1dWB!a\u0005\u0013&j\u0013\tIuEA\u0005Gk:\u001cG/[8ocA\u00191j\u0015,\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(\u0011\u0003\u0019a$o\\8u}%\t\u0001&\u0003\u0002SO\u00059\u0001/Y2lC\u001e,\u0017B\u0001+V\u0005\u0011a\u0015n\u001d;\u000b\u0005I;\u0003CA,g\u001d\tA6M\u0004\u0002ZC:\u0011!\f\u0019\b\u00037~s!\u0001\u00180\u000f\u00055k\u0016\"A\u000e\n\u0005eQ\u0012BA\b\u0019\u0013\tYt#\u0003\u0002cu\u00059Q.Z:tC\u001e,\u0017B\u00013f\u0003]a\u0015n\u001d;PM\u001a\u001cX\r^:SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0002cu%\u0011q\r\u001b\u0002\u0019\u0019&\u001cHo\u00144gg\u0016$8\u000fV8qS\u000e\u0014Vm\u001d9p]N,'B\u00013f!\t1#.\u0003\u0002lO\t!QK\\5u\u0003\u0019a\u0014N\\5u}Q1an\u001c9reN\u0004\"a\u0010\u0001\t\u000b\u00112\u0001\u0019A\u0013\t\u000b-2\u0001\u0019\u0001\u0017\t\u000b=2\u0001\u0019\u0001\u0019\t\u000b\t3\u0001\u0019A\"\t\u000b\u00193\u0001\u0019A$\u0002\u0019=tW\t\u001f9je\u0006$\u0018n\u001c8\u0015\u0003%\f!b\u001c8D_6\u0004H.\u001a;f\u0003-!(/_\"p[BdW\r^3\u0015\u0003e\u0004\"A\n>\n\u0005m<#a\u0002\"p_2,\u0017M\\\u0001\u0013EVLG\u000eZ#se>\u0014(+Z:q_:\u001cX\rF\u0003\u007f\u0003\u0007\t\u0019\u0002\u0005\u0002X\u007f&\u0019\u0011\u0011\u00015\u000391K7\u000f^(gMN,Go\u001d)beRLG/[8o%\u0016\u001c\bo\u001c8tK\"9\u0011Q\u0001\u0006A\u0002\u0005\u001d\u0011!A3\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004;\u0003!\u0001(o\u001c;pG>d\u0017\u0002BA\t\u0003\u0017\u0011a!\u0012:s_J\u001c\bBBA\u000b\u0015\u0001\u0007A&\u0001\bqCJ$\u0018\u000e^5p]&sG-\u001a=")
public class DelayedRemoteListOffsets
extends DelayedOperation
implements Logging {
    private final int version;
    private final Map<TopicPartition, ListOffsetsPartitionStatus> statusByPartition;
    private final ReplicaManager replicaManager;
    private final Function1<List<ListOffsetsResponseData.ListOffsetsTopicResponse>, BoxedUnit> responseCallback;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void onExpiration() {
        this.statusByPartition.foreachEntry((Function2 & Serializable)(topicPartition, status) -> {
            DelayedRemoteListOffsets.$anonfun$onExpiration$1(this, topicPartition, status);
            return BoxedUnit.UNIT;
        });
    }

    public void onComplete() {
        List responseTopics = ((IterableOnceOps)this.statusByPartition.groupBy((Function1 & Serializable)e -> ((TopicPartition)e._1()).topic()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                Map status = (Map)x0$1._2();
                return new ListOffsetsResponseData.ListOffsetsTopicResponse().setName(topic).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)status.values().flatMap((Function1 & Serializable)s -> s.responseOpt())).toList()).asJava());
            }
            throw new MatchError(null);
        })).toList();
        this.responseCallback.apply((Object)responseTopics);
    }

    public boolean tryComplete() {
        BooleanRef completable = BooleanRef.create((boolean)true);
        this.statusByPartition.foreachEntry((Function2 & Serializable)(partition, status) -> {
            DelayedRemoteListOffsets.$anonfun$tryComplete$1(this, completable, partition, status);
            return BoxedUnit.UNIT;
        });
        if (completable.elem) {
            return this.forceComplete();
        }
        return false;
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse buildErrorResponse(Errors e, int partitionIndex) {
        return new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(partitionIndex).setErrorCode(e.code()).setTimestamp(-1L).setOffset(-1L);
    }

    public static final /* synthetic */ void $anonfun$new$1(DelayedRemoteListOffsets $this, TopicPartition topicPartition, ListOffsetsPartitionStatus status) {
        status.completed_$eq(status.futureHolderOpt().isEmpty());
        if (status.futureHolderOpt().isPresent()) {
            status.responseOpt_$eq((Option<ListOffsetsResponseData.ListOffsetsPartitionResponse>)new Some((Object)$this.buildErrorResponse(Errors.REQUEST_TIMED_OUT, topicPartition.partition())));
        }
        $this.trace((Function0<String>)(Function0 & Serializable)() -> "Initial partition status for " + topicPartition + " is " + status);
    }

    public static final /* synthetic */ void $anonfun$onExpiration$1(DelayedRemoteListOffsets $this, TopicPartition topicPartition, ListOffsetsPartitionStatus status) {
        if (!status.completed()) {
            $this.debug((Function0<String>)(Function0 & Serializable)() -> "Expiring list offset request for partition " + topicPartition + " with status " + status);
            status.futureHolderOpt().ifPresent(futureHolder -> futureHolder.jobFuture().cancel(true));
            DelayedRemoteListOffsetsMetrics$.MODULE$.recordExpiration(topicPartition);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$tryComplete$1(DelayedRemoteListOffsets $this, BooleanRef completable$1, TopicPartition partition, ListOffsetsPartitionStatus status) {
        if (!status.completed()) {
            try {
                $this.replicaManager.getPartitionOrException(partition);
            }
            catch (ApiException e) {
                status.futureHolderOpt().ifPresent(futureHolder -> {
                    futureHolder.jobFuture().cancel(false);
                    futureHolder.taskFuture().complete(new OffsetResultHolder.FileRecordsOrError(Optional.of(e), Optional.empty()));
                });
            }
            status.futureHolderOpt().ifPresent(futureHolder -> {
                if (futureHolder.taskFuture().isDone()) {
                    ListOffsetsResponseData.ListOffsetsPartitionResponse listOffsetsPartitionResponse;
                    OffsetResultHolder.FileRecordsOrError taskFuture = (OffsetResultHolder.FileRecordsOrError)futureHolder.taskFuture().get();
                    if (taskFuture.hasException()) {
                        listOffsetsPartitionResponse = $this.buildErrorResponse(Errors.forException((Throwable)((Throwable)taskFuture.exception().get())), partition.partition());
                    } else if (!taskFuture.hasTimestampAndOffset()) {
                        Errors error = (Errors)status.maybeOffsetsError().map((Function1 & Serializable)e -> {
                            if ($this.version >= 5) {
                                return Errors.forException((Throwable)e);
                            }
                            return Errors.LEADER_NOT_AVAILABLE;
                        }).getOrElse((Function0 & Serializable)() -> Errors.NONE);
                        listOffsetsPartitionResponse = $this.buildErrorResponse(error, partition.partition());
                    } else {
                        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionResponse = $this.buildErrorResponse(Errors.NONE, partition.partition());
                        FileRecords.TimestampAndOffset found = (FileRecords.TimestampAndOffset)taskFuture.timestampAndOffset().get();
                        if (status.lastFetchableOffset().isDefined() && found.offset >= BoxesRunTime.unboxToLong((Object)status.lastFetchableOffset().get())) {
                            if (status.maybeOffsetsError().isDefined()) {
                                Errors error = $this.version >= 5 ? Errors.forException((Throwable)((Throwable)status.maybeOffsetsError().get())) : Errors.LEADER_NOT_AVAILABLE;
                                partitionResponse.setErrorCode(error.code());
                            }
                        } else {
                            partitionResponse = new ListOffsetsResponseData.ListOffsetsPartitionResponse().setPartitionIndex(partition.partition()).setErrorCode(Errors.NONE.code()).setTimestamp(found.timestamp).setOffset(found.offset);
                            if (found.leaderEpoch.isPresent() && $this.version >= 4) {
                                partitionResponse.setLeaderEpoch(Predef$.MODULE$.Integer2int((Integer)found.leaderEpoch.get()));
                            }
                        }
                        listOffsetsPartitionResponse = partitionResponse;
                    }
                    ListOffsetsResponseData.ListOffsetsPartitionResponse response = listOffsetsPartitionResponse;
                    status.responseOpt_$eq((Option<ListOffsetsResponseData.ListOffsetsPartitionResponse>)new Some((Object)response));
                    status.completed_$eq(true);
                }
                completable$1.elem = completable$1.elem && futureHolder.taskFuture().isDone();
            });
            return;
        }
    }

    public DelayedRemoteListOffsets(long delayMs, int version, Map<TopicPartition, ListOffsetsPartitionStatus> statusByPartition, ReplicaManager replicaManager, Function1<List<ListOffsetsResponseData.ListOffsetsTopicResponse>, BoxedUnit> responseCallback) {
        this.version = version;
        this.statusByPartition = statusByPartition;
        this.replicaManager = replicaManager;
        this.responseCallback = responseCallback;
        super(delayMs);
        statusByPartition.foreachEntry((Function2 & Serializable)(topicPartition, status) -> {
            DelayedRemoteListOffsets.$anonfun$new$1(this, topicPartition, status);
            return BoxedUnit.UNIT;
        });
    }
}

