/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.mirror;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.mirror.MirrorSourceConfig;
import org.apache.kafka.connect.mirror.MirrorSourceMetrics;
import org.apache.kafka.connect.mirror.MirrorUtils;

public class MirrorSourceTaskConfig
extends MirrorSourceConfig {
    private static final String TASK_TOPIC_PARTITIONS_DOC = "Topic-partitions assigned to this task to replicate.";
    protected static final ConfigDef TASK_CONFIG_DEF = new ConfigDef(CONNECTOR_CONFIG_DEF).define("task.assigned.partitions", ConfigDef.Type.LIST, null, ConfigDef.Importance.LOW, "Topic-partitions assigned to this task to replicate.").define("task.index", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The index of the task");

    public MirrorSourceTaskConfig(Map<String, String> props) {
        super(TASK_CONFIG_DEF, props);
    }

    Set<TopicPartition> taskTopicPartitions() {
        List fields = this.getList("task.assigned.partitions");
        if (fields == null || fields.isEmpty()) {
            return Collections.emptySet();
        }
        return fields.stream().map(MirrorUtils::decodeTopicPartition).collect(Collectors.toSet());
    }

    MirrorSourceMetrics metrics() {
        MirrorSourceMetrics metrics = new MirrorSourceMetrics(this);
        this.metricsReporters().forEach(metrics::addReporter);
        return metrics;
    }

    @Override
    String entityLabel() {
        return super.entityLabel() + "-" + String.valueOf(this.getInt("task.index") == null ? "?" : this.getInt("task.index"));
    }
}

