/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.InitializeShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryRequestData;
import org.apache.kafka.common.message.ReadShareGroupStateSummaryResponseData;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.DeleteShareGroupStateResponse;
import org.apache.kafka.common.requests.InitializeShareGroupStateResponse;
import org.apache.kafka.common.requests.ReadShareGroupStateResponse;
import org.apache.kafka.common.requests.ReadShareGroupStateSummaryResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteShareGroupStateResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorExecutor;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetrics;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.common.runtime.CoordinatorShard;
import org.apache.kafka.coordinator.common.runtime.CoordinatorShardBuilder;
import org.apache.kafka.coordinator.common.runtime.CoordinatorTimer;
import org.apache.kafka.coordinator.share.PersisterStateBatchCombiner;
import org.apache.kafka.coordinator.share.ShareCoordinatorConfig;
import org.apache.kafka.coordinator.share.ShareCoordinatorOffsetsManager;
import org.apache.kafka.coordinator.share.ShareCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.share.ShareGroupOffset;
import org.apache.kafka.coordinator.share.generated.CoordinatorRecordType;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotKey;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateKey;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;
import org.apache.kafka.coordinator.share.metrics.ShareCoordinatorMetrics;
import org.apache.kafka.coordinator.share.metrics.ShareCoordinatorMetricsShard;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.share.SharePartitionKey;
import org.apache.kafka.server.share.persister.PersisterStateBatch;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.slf4j.Logger;

public class ShareCoordinatorShard
implements CoordinatorShard<CoordinatorRecord> {
    private final Logger log;
    private final ShareCoordinatorConfig config;
    private final CoordinatorMetrics coordinatorMetrics;
    private final CoordinatorMetricsShard metricsShard;
    private final TimelineHashMap<SharePartitionKey, ShareGroupOffset> shareStateMap;
    private final TimelineHashMap<SharePartitionKey, Integer> leaderEpochMap;
    private final TimelineHashMap<SharePartitionKey, Integer> snapshotUpdateCount;
    private final TimelineHashMap<SharePartitionKey, Integer> stateEpochMap;
    private MetadataImage metadataImage;
    private final ShareCoordinatorOffsetsManager offsetsManager;
    private final Time time;
    public static final Exception NULL_TOPIC_ID = new Exception("The topic id cannot be null.");
    public static final Exception NEGATIVE_PARTITION_ID = new Exception("The partition id cannot be a negative number.");
    public static final Exception WRITE_UNINITIALIZED_SHARE_PARTITION = new Exception("Write operation on uninitialized share partition not allowed.");
    public static final Exception READ_UNINITIALIZED_SHARE_PARTITION = new Exception("Read operation on uninitialized share partition not allowed.");

    ShareCoordinatorShard(LogContext logContext, ShareCoordinatorConfig config, CoordinatorMetrics coordinatorMetrics, CoordinatorMetricsShard metricsShard, SnapshotRegistry snapshotRegistry, Time time) {
        this(logContext, config, coordinatorMetrics, metricsShard, snapshotRegistry, new ShareCoordinatorOffsetsManager(snapshotRegistry), time);
    }

    ShareCoordinatorShard(LogContext logContext, ShareCoordinatorConfig config, CoordinatorMetrics coordinatorMetrics, CoordinatorMetricsShard metricsShard, SnapshotRegistry snapshotRegistry, ShareCoordinatorOffsetsManager offsetsManager, Time time) {
        this.log = logContext.logger(ShareCoordinatorShard.class);
        this.config = config;
        this.coordinatorMetrics = coordinatorMetrics;
        this.metricsShard = metricsShard;
        this.shareStateMap = new TimelineHashMap(snapshotRegistry, 0);
        this.leaderEpochMap = new TimelineHashMap(snapshotRegistry, 0);
        this.snapshotUpdateCount = new TimelineHashMap(snapshotRegistry, 0);
        this.stateEpochMap = new TimelineHashMap(snapshotRegistry, 0);
        this.offsetsManager = offsetsManager;
        this.time = time;
    }

    public void onLoaded(MetadataImage newImage) {
        this.coordinatorMetrics.activateMetricsShard(this.metricsShard);
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.metadataImage = newImage;
    }

    public void onUnloaded() {
        this.coordinatorMetrics.deactivateMetricsShard(this.metricsShard);
    }

    public void replay(long offset, long producerId, short producerEpoch, CoordinatorRecord record) throws RuntimeException {
        ApiMessage key = record.key();
        ApiMessageAndVersion value = record.value();
        try {
            switch (CoordinatorRecordType.fromId(key.apiKey())) {
                case SHARE_SNAPSHOT: {
                    this.handleShareSnapshot((ShareSnapshotKey)key, (ShareSnapshotValue)ShareCoordinatorShard.messageOrNull(value), offset);
                    break;
                }
                case SHARE_UPDATE: {
                    this.handleShareUpdate((ShareUpdateKey)key, (ShareUpdateValue)ShareCoordinatorShard.messageOrNull(value));
                    break;
                }
            }
        }
        catch (UnsupportedVersionException unsupportedVersionException) {
            // empty catch block
        }
    }

    private void handleShareSnapshot(ShareSnapshotKey key, ShareSnapshotValue value, long offset) {
        SharePartitionKey mapKey = SharePartitionKey.getInstance((String)key.groupId(), (Uuid)key.topicId(), (int)key.partition());
        if (value == null) {
            this.log.debug("Tombstone records received for share partition key: {}", (Object)mapKey);
            this.shareStateMap.remove((Object)mapKey);
            this.leaderEpochMap.remove((Object)mapKey);
            this.stateEpochMap.remove((Object)mapKey);
            this.snapshotUpdateCount.remove((Object)mapKey);
        } else {
            this.maybeUpdateLeaderEpochMap(mapKey, value.leaderEpoch());
            this.maybeUpdateStateEpochMap(mapKey, value.stateEpoch());
            ShareGroupOffset offsetRecord = ShareGroupOffset.fromRecord(value);
            this.shareStateMap.put((Object)mapKey, (Object)offsetRecord);
            if (this.snapshotUpdateCount.containsKey((Object)mapKey) && (Integer)this.snapshotUpdateCount.get((Object)mapKey) >= this.config.shareCoordinatorSnapshotUpdateRecordsPerSnapshot()) {
                this.snapshotUpdateCount.put((Object)mapKey, (Object)0);
            }
        }
        this.offsetsManager.updateState(mapKey, offset);
    }

    private void handleShareUpdate(ShareUpdateKey key, ShareUpdateValue value) {
        SharePartitionKey mapKey = SharePartitionKey.getInstance((String)key.groupId(), (Uuid)key.topicId(), (int)key.partition());
        this.maybeUpdateLeaderEpochMap(mapKey, value.leaderEpoch());
        ShareGroupOffset offsetRecord = ShareGroupOffset.fromRecord(value);
        this.shareStateMap.compute((Object)mapKey, (k, v) -> v == null ? offsetRecord : ShareCoordinatorShard.merge(v, value));
        this.snapshotUpdateCount.compute((Object)mapKey, (k, v) -> v == null ? 0 : v + 1);
    }

    private void maybeUpdateLeaderEpochMap(SharePartitionKey mapKey, int leaderEpoch) {
        this.leaderEpochMap.putIfAbsent((Object)mapKey, (Object)leaderEpoch);
        if ((Integer)this.leaderEpochMap.get((Object)mapKey) < leaderEpoch) {
            this.leaderEpochMap.put((Object)mapKey, (Object)leaderEpoch);
        }
    }

    private void maybeUpdateStateEpochMap(SharePartitionKey mapKey, int stateEpoch) {
        this.stateEpochMap.putIfAbsent((Object)mapKey, (Object)stateEpoch);
        if ((Integer)this.stateEpochMap.get((Object)mapKey) < stateEpoch) {
            this.stateEpochMap.put((Object)mapKey, (Object)stateEpoch);
        }
    }

    public void replayEndTransactionMarker(long producerId, short producerEpoch, TransactionResult result) throws RuntimeException {
        super.replayEndTransactionMarker(producerId, producerEpoch, result);
    }

    public CoordinatorResult<WriteShareGroupStateResponseData, CoordinatorRecord> writeState(WriteShareGroupStateRequestData request) {
        this.metricsShard.record("ShareCoordinatorWrite");
        Optional<CoordinatorResult<WriteShareGroupStateResponseData, CoordinatorRecord>> error = this.maybeGetWriteStateError(request);
        if (error.isPresent()) {
            return error.get();
        }
        WriteShareGroupStateRequestData.WriteStateData topicData = (WriteShareGroupStateRequestData.WriteStateData)request.topics().get(0);
        WriteShareGroupStateRequestData.PartitionData partitionData = (WriteShareGroupStateRequestData.PartitionData)topicData.partitions().get(0);
        SharePartitionKey key = SharePartitionKey.getInstance((String)request.groupId(), (Uuid)topicData.topicId(), (int)partitionData.partition());
        CoordinatorRecord record = this.generateShareStateRecord(partitionData, key);
        WriteShareGroupStateResponseData responseData = new WriteShareGroupStateResponseData().setResults(List.of(WriteShareGroupStateResponse.toResponseWriteStateResult((Uuid)key.topicId(), List.of(WriteShareGroupStateResponse.toResponsePartitionResult((int)key.partition())))));
        return new CoordinatorResult(List.of(record), (Object)responseData);
    }

    public CoordinatorResult<ReadShareGroupStateResponseData, CoordinatorRecord> readStateAndMaybeUpdateLeaderEpoch(ReadShareGroupStateRequestData request) {
        Optional<ReadShareGroupStateResponseData> error = this.maybeGetReadStateError(request);
        if (error.isPresent()) {
            return new CoordinatorResult(List.of(), (Object)error.get());
        }
        ReadShareGroupStateRequestData.ReadStateData topicData = (ReadShareGroupStateRequestData.ReadStateData)request.topics().get(0);
        ReadShareGroupStateRequestData.PartitionData partitionData = (ReadShareGroupStateRequestData.PartitionData)topicData.partitions().get(0);
        Uuid topicId = topicData.topicId();
        int partitionId = partitionData.partition();
        int leaderEpoch = partitionData.leaderEpoch();
        SharePartitionKey key = SharePartitionKey.getInstance((String)request.groupId(), (Uuid)topicId, (int)partitionId);
        ShareGroupOffset offsetValue = (ShareGroupOffset)this.shareStateMap.get((Object)key);
        List stateBatches = offsetValue.stateBatches() != null && !offsetValue.stateBatches().isEmpty() ? offsetValue.stateBatches().stream().map(stateBatch -> new ReadShareGroupStateResponseData.StateBatch().setFirstOffset(stateBatch.firstOffset()).setLastOffset(stateBatch.lastOffset()).setDeliveryState(stateBatch.deliveryState()).setDeliveryCount(stateBatch.deliveryCount())).toList() : List.of();
        ReadShareGroupStateResponseData responseData = ReadShareGroupStateResponse.toResponseData((Uuid)topicId, (int)partitionId, (long)offsetValue.startOffset(), (int)offsetValue.stateEpoch(), stateBatches);
        if (leaderEpoch == -1 || this.leaderEpochMap.get((Object)key) != null && (Integer)this.leaderEpochMap.get((Object)key) == leaderEpoch) {
            return new CoordinatorResult(List.of(), (Object)responseData);
        }
        this.log.info("Read with leader epoch update call for key {} having new leader epoch {}.", (Object)key, (Object)leaderEpoch);
        this.metricsShard.record("ShareCoordinatorWrite");
        WriteShareGroupStateRequestData.PartitionData writePartitionData = new WriteShareGroupStateRequestData.PartitionData().setPartition(partitionId).setLeaderEpoch(leaderEpoch).setStateBatches(List.of()).setStartOffset(((ReadShareGroupStateResponseData.PartitionResult)((ReadShareGroupStateResponseData.ReadStateResult)responseData.results().get(0)).partitions().get(0)).startOffset()).setStateEpoch(((ReadShareGroupStateResponseData.PartitionResult)((ReadShareGroupStateResponseData.ReadStateResult)responseData.results().get(0)).partitions().get(0)).stateEpoch());
        CoordinatorRecord record = this.generateShareStateRecord(writePartitionData, key);
        return new CoordinatorResult(List.of(record), (Object)responseData);
    }

    public CoordinatorResult<ReadShareGroupStateSummaryResponseData, CoordinatorRecord> readStateSummary(ReadShareGroupStateSummaryRequestData request) {
        Optional<ReadShareGroupStateSummaryResponseData> error = this.maybeGetReadStateSummaryError(request);
        if (error.isPresent()) {
            return new CoordinatorResult(List.of(), (Object)error.get());
        }
        ReadShareGroupStateSummaryRequestData.ReadStateSummaryData topicData = (ReadShareGroupStateSummaryRequestData.ReadStateSummaryData)request.topics().get(0);
        ReadShareGroupStateSummaryRequestData.PartitionData partitionData = (ReadShareGroupStateSummaryRequestData.PartitionData)topicData.partitions().get(0);
        Uuid topicId = topicData.topicId();
        int partitionId = partitionData.partition();
        SharePartitionKey key = SharePartitionKey.getInstance((String)request.groupId(), (Uuid)topicId, (int)partitionId);
        ReadShareGroupStateSummaryResponseData responseData = null;
        if (!this.shareStateMap.containsKey((Object)key)) {
            responseData = ReadShareGroupStateSummaryResponse.toResponseData((Uuid)topicId, (int)partitionId, (long)-1L, (int)0, (int)0);
        } else {
            ShareGroupOffset offsetValue = (ShareGroupOffset)this.shareStateMap.get((Object)key);
            if (offsetValue == null) {
                this.log.error("Data not found for topic {}, partition {} for group {}, in the in-memory state of share coordinator", new Object[]{topicId, partitionId, request.groupId()});
                responseData = ReadShareGroupStateSummaryResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.UNKNOWN_SERVER_ERROR, (String)("Data not found for the topics " + String.valueOf(topicId) + ", partition " + partitionId + " for group " + request.groupId() + ", in the in-memory state of share coordinator"));
            } else {
                responseData = ReadShareGroupStateSummaryResponse.toResponseData((Uuid)topicId, (int)partitionId, (long)offsetValue.startOffset(), (int)offsetValue.leaderEpoch(), (int)offsetValue.stateEpoch());
            }
        }
        return new CoordinatorResult(List.of(), (Object)responseData);
    }

    public CoordinatorResult<Optional<Long>, CoordinatorRecord> lastRedundantOffset() {
        return new CoordinatorResult(List.of(), this.offsetsManager.lastRedundantOffset());
    }

    public CoordinatorResult<DeleteShareGroupStateResponseData, CoordinatorRecord> deleteState(DeleteShareGroupStateRequestData request) {
        Optional<CoordinatorResult<DeleteShareGroupStateResponseData, CoordinatorRecord>> error = this.maybeGetDeleteStateError(request);
        if (error.isPresent()) {
            return error.get();
        }
        DeleteShareGroupStateRequestData.DeleteStateData topicData = (DeleteShareGroupStateRequestData.DeleteStateData)request.topics().get(0);
        DeleteShareGroupStateRequestData.PartitionData partitionData = (DeleteShareGroupStateRequestData.PartitionData)topicData.partitions().get(0);
        SharePartitionKey key = SharePartitionKey.getInstance((String)request.groupId(), (Uuid)topicData.topicId(), (int)partitionData.partition());
        if (!this.shareStateMap.containsKey((Object)key)) {
            this.log.warn("Attempted to delete non-existent share partition {}.", (Object)key);
            return new CoordinatorResult(List.of(), (Object)new DeleteShareGroupStateResponseData().setResults(List.of(DeleteShareGroupStateResponse.toResponseDeleteStateResult((Uuid)key.topicId(), List.of(DeleteShareGroupStateResponse.toResponsePartitionResult((int)key.partition()))))));
        }
        CoordinatorRecord record = this.generateTombstoneRecord(key);
        DeleteShareGroupStateResponseData responseData = new DeleteShareGroupStateResponseData().setResults(List.of(DeleteShareGroupStateResponse.toResponseDeleteStateResult((Uuid)key.topicId(), List.of(DeleteShareGroupStateResponse.toResponsePartitionResult((int)key.partition())))));
        return new CoordinatorResult(List.of(record), (Object)responseData);
    }

    public CoordinatorResult<InitializeShareGroupStateResponseData, CoordinatorRecord> initializeState(InitializeShareGroupStateRequestData request) {
        Optional<CoordinatorResult<InitializeShareGroupStateResponseData, CoordinatorRecord>> error = this.maybeGetInitializeStateError(request);
        if (error.isPresent()) {
            return error.get();
        }
        InitializeShareGroupStateRequestData.InitializeStateData topicData = (InitializeShareGroupStateRequestData.InitializeStateData)request.topics().get(0);
        InitializeShareGroupStateRequestData.PartitionData partitionData = (InitializeShareGroupStateRequestData.PartitionData)topicData.partitions().get(0);
        SharePartitionKey key = SharePartitionKey.getInstance((String)request.groupId(), (Uuid)topicData.topicId(), (int)partitionData.partition());
        CoordinatorRecord record = this.generateInitializeStateRecord(partitionData, key);
        InitializeShareGroupStateResponseData responseData = new InitializeShareGroupStateResponseData().setResults(List.of(InitializeShareGroupStateResponse.toResponseInitializeStateResult((Uuid)key.topicId(), List.of(InitializeShareGroupStateResponse.toResponsePartitionResult((int)key.partition())))));
        return new CoordinatorResult(List.of(record), (Object)responseData);
    }

    public CoordinatorResult<Void, CoordinatorRecord> snapshotColdPartitions() {
        long coldSnapshottedPartitionsCount = this.shareStateMap.values().stream().filter(shareGroupOffset -> shareGroupOffset.createTimestamp() - shareGroupOffset.writeTimestamp() != 0L).count();
        if (coldSnapshottedPartitionsCount == (long)this.shareStateMap.size()) {
            this.log.debug("All share snapshot records already cold snapshotted, skipping.");
            return new CoordinatorResult(List.of(), null);
        }
        ArrayList records = new ArrayList();
        this.shareStateMap.forEach((sharePartitionKey, shareGroupOffset) -> {
            long timeSinceLastSnapshot = this.time.milliseconds() - shareGroupOffset.writeTimestamp();
            if (timeSinceLastSnapshot >= (long)this.config.shareCoordinatorColdPartitionSnapshotIntervalMs()) {
                this.log.info("Last snapshot for {} is older than allowed interval.", sharePartitionKey);
                records.add(ShareCoordinatorRecordHelpers.newShareSnapshotRecord(sharePartitionKey.groupId(), sharePartitionKey.topicId(), sharePartitionKey.partition(), shareGroupOffset.builderSupplier().setSnapshotEpoch(shareGroupOffset.snapshotEpoch() + 1).setWriteTimestamp(this.time.milliseconds()).build()));
            }
        });
        return new CoordinatorResult(records, null);
    }

    public CoordinatorResult<Void, CoordinatorRecord> maybeCleanupShareState(Set<Uuid> deletedTopicIds) {
        if (deletedTopicIds.isEmpty()) {
            return new CoordinatorResult(List.of());
        }
        HashSet eligibleKeys = new HashSet();
        this.shareStateMap.forEach((key, __) -> {
            if (deletedTopicIds.contains(key.topicId())) {
                eligibleKeys.add(key);
            }
        });
        return new CoordinatorResult(eligibleKeys.stream().map(key -> ShareCoordinatorRecordHelpers.newShareStateTombstoneRecord(key.groupId(), key.topicId(), key.partition())).toList());
    }

    private CoordinatorRecord generateShareStateRecord(WriteShareGroupStateRequestData.PartitionData partitionData, SharePartitionKey key) {
        long timestamp = this.time.milliseconds();
        int updatesPerSnapshotLimit = this.config.shareCoordinatorSnapshotUpdateRecordsPerSnapshot();
        if ((Integer)this.snapshotUpdateCount.getOrDefault((Object)key, (Object)0) >= updatesPerSnapshotLimit || partitionData.stateEpoch() > ((ShareGroupOffset)this.shareStateMap.get((Object)key)).stateEpoch()) {
            ShareGroupOffset currentState = (ShareGroupOffset)this.shareStateMap.get((Object)key);
            int newLeaderEpoch = partitionData.leaderEpoch() == -1 ? currentState.leaderEpoch() : partitionData.leaderEpoch();
            int newStateEpoch = partitionData.stateEpoch() == -1 ? currentState.stateEpoch() : partitionData.stateEpoch();
            long newStartOffset = partitionData.startOffset() == -1L ? currentState.startOffset() : partitionData.startOffset();
            return ShareCoordinatorRecordHelpers.newShareSnapshotRecord(key.groupId(), key.topicId(), partitionData.partition(), new ShareGroupOffset.Builder().setSnapshotEpoch(currentState.snapshotEpoch() + 1).setStartOffset(newStartOffset).setLeaderEpoch(newLeaderEpoch).setStateEpoch(newStateEpoch).setStateBatches(this.mergeBatches(currentState.stateBatches(), partitionData, newStartOffset)).setCreateTimestamp(timestamp).setWriteTimestamp(timestamp).build());
        }
        ShareGroupOffset currentState = (ShareGroupOffset)this.shareStateMap.get((Object)key);
        return ShareCoordinatorRecordHelpers.newShareUpdateRecord(key.groupId(), key.topicId(), partitionData.partition(), new ShareGroupOffset.Builder().setSnapshotEpoch(currentState.snapshotEpoch()).setStartOffset(partitionData.startOffset()).setLeaderEpoch(partitionData.leaderEpoch()).setStateBatches(this.mergeBatches(List.of(), partitionData)).build());
    }

    private CoordinatorRecord generateTombstoneRecord(SharePartitionKey key) {
        return ShareCoordinatorRecordHelpers.newShareStateTombstoneRecord(key.groupId(), key.topicId(), key.partition());
    }

    private CoordinatorRecord generateInitializeStateRecord(InitializeShareGroupStateRequestData.PartitionData partitionData, SharePartitionKey key) {
        int snapshotEpoch = this.shareStateMap.containsKey((Object)key) ? ((ShareGroupOffset)this.shareStateMap.get((Object)key)).snapshotEpoch() + 1 : 0;
        return ShareCoordinatorRecordHelpers.newShareSnapshotRecord(key.groupId(), key.topicId(), key.partition(), ShareGroupOffset.fromRequest(partitionData, snapshotEpoch, this.time.milliseconds()));
    }

    private List<PersisterStateBatch> mergeBatches(List<PersisterStateBatch> soFar, WriteShareGroupStateRequestData.PartitionData partitionData) {
        return this.mergeBatches(soFar, partitionData, partitionData.startOffset());
    }

    private List<PersisterStateBatch> mergeBatches(List<PersisterStateBatch> soFar, WriteShareGroupStateRequestData.PartitionData partitionData, long startOffset) {
        return new PersisterStateBatchCombiner(soFar, partitionData.stateBatches().stream().map(PersisterStateBatch::from).toList(), startOffset).combineStateBatches();
    }

    private Optional<CoordinatorResult<WriteShareGroupStateResponseData, CoordinatorRecord>> maybeGetWriteStateError(WriteShareGroupStateRequestData request) {
        String groupId = request.groupId();
        WriteShareGroupStateRequestData.WriteStateData topicData = (WriteShareGroupStateRequestData.WriteStateData)request.topics().get(0);
        WriteShareGroupStateRequestData.PartitionData partitionData = (WriteShareGroupStateRequestData.PartitionData)topicData.partitions().get(0);
        Uuid topicId = topicData.topicId();
        int partitionId = partitionData.partition();
        if (topicId == null) {
            return Optional.of(this.getWriteErrorCoordinatorResult(Errors.INVALID_REQUEST, NULL_TOPIC_ID, null, partitionId));
        }
        if (partitionId < 0) {
            return Optional.of(this.getWriteErrorCoordinatorResult(Errors.INVALID_REQUEST, NEGATIVE_PARTITION_ID, topicId, partitionId));
        }
        SharePartitionKey mapKey = SharePartitionKey.getInstance((String)groupId, (Uuid)topicId, (int)partitionId);
        if (!this.shareStateMap.containsKey((Object)mapKey)) {
            return Optional.of(this.getWriteErrorCoordinatorResult(Errors.INVALID_REQUEST, WRITE_UNINITIALIZED_SHARE_PARTITION, topicId, partitionId));
        }
        if (partitionData.leaderEpoch() != -1 && this.leaderEpochMap.containsKey((Object)mapKey) && (Integer)this.leaderEpochMap.get((Object)mapKey) > partitionData.leaderEpoch()) {
            this.log.error("Write request leader epoch is smaller than last recorded current: {}, requested: {}.", this.leaderEpochMap.get((Object)mapKey), (Object)partitionData.leaderEpoch());
            return Optional.of(this.getWriteErrorCoordinatorResult(Errors.FENCED_LEADER_EPOCH, null, topicId, partitionId));
        }
        if (partitionData.stateEpoch() != -1 && this.stateEpochMap.containsKey((Object)mapKey) && (Integer)this.stateEpochMap.get((Object)mapKey) > partitionData.stateEpoch()) {
            this.log.info("Write request state epoch is smaller than last recorded current: {}, requested: {}.", this.stateEpochMap.get((Object)mapKey), (Object)partitionData.stateEpoch());
            return Optional.of(this.getWriteErrorCoordinatorResult(Errors.FENCED_STATE_EPOCH, null, topicId, partitionId));
        }
        if (this.metadataImage == null) {
            this.log.error("Metadata image is null");
            return Optional.of(this.getWriteErrorCoordinatorResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, null, topicId, partitionId));
        }
        if (this.metadataImage.topics().getTopic(topicId) == null || this.metadataImage.topics().getPartition(topicId, partitionId) == null) {
            this.log.error("Topic/TopicPartition not found in metadata image.");
            return Optional.of(this.getWriteErrorCoordinatorResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, null, topicId, partitionId));
        }
        return Optional.empty();
    }

    private Optional<ReadShareGroupStateResponseData> maybeGetReadStateError(ReadShareGroupStateRequestData request) {
        String groupId = request.groupId();
        ReadShareGroupStateRequestData.ReadStateData topicData = (ReadShareGroupStateRequestData.ReadStateData)request.topics().get(0);
        ReadShareGroupStateRequestData.PartitionData partitionData = (ReadShareGroupStateRequestData.PartitionData)topicData.partitions().get(0);
        Uuid topicId = topicData.topicId();
        int partitionId = partitionData.partition();
        if (topicId == null) {
            this.log.error("Request topic id is null.");
            return Optional.of(ReadShareGroupStateResponse.toErrorResponseData(null, (int)partitionId, (Errors)Errors.INVALID_REQUEST, (String)NULL_TOPIC_ID.getMessage()));
        }
        if (partitionId < 0) {
            this.log.error("Request partition id is negative.");
            return Optional.of(ReadShareGroupStateResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.INVALID_REQUEST, (String)NEGATIVE_PARTITION_ID.getMessage()));
        }
        SharePartitionKey mapKey = SharePartitionKey.getInstance((String)groupId, (Uuid)topicId, (int)partitionId);
        if (!this.shareStateMap.containsKey((Object)mapKey)) {
            this.log.error("Read on uninitialized share partition {}", (Object)mapKey);
            return Optional.of(ReadShareGroupStateResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.INVALID_REQUEST, (String)READ_UNINITIALIZED_SHARE_PARTITION.getMessage()));
        }
        if (this.leaderEpochMap.containsKey((Object)mapKey) && (Integer)this.leaderEpochMap.get((Object)mapKey) > partitionData.leaderEpoch()) {
            this.log.error("Read request leader epoch is smaller than last recorded current: {}, requested: {}.", this.leaderEpochMap.get((Object)mapKey), (Object)partitionData.leaderEpoch());
            return Optional.of(ReadShareGroupStateResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.FENCED_LEADER_EPOCH, (String)Errors.FENCED_LEADER_EPOCH.message()));
        }
        if (this.metadataImage == null) {
            this.log.error("Metadata image is null");
            return Optional.of(ReadShareGroupStateResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.UNKNOWN_TOPIC_OR_PARTITION, (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message()));
        }
        if (this.metadataImage.topics().getTopic(topicId) == null || this.metadataImage.topics().getPartition(topicId, partitionId) == null) {
            this.log.error("Topic/TopicPartition not found in metadata image.");
            return Optional.of(ReadShareGroupStateResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.UNKNOWN_TOPIC_OR_PARTITION, (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message()));
        }
        return Optional.empty();
    }

    private Optional<ReadShareGroupStateSummaryResponseData> maybeGetReadStateSummaryError(ReadShareGroupStateSummaryRequestData request) {
        ReadShareGroupStateSummaryRequestData.ReadStateSummaryData topicData = (ReadShareGroupStateSummaryRequestData.ReadStateSummaryData)request.topics().get(0);
        ReadShareGroupStateSummaryRequestData.PartitionData partitionData = (ReadShareGroupStateSummaryRequestData.PartitionData)topicData.partitions().get(0);
        Uuid topicId = topicData.topicId();
        int partitionId = partitionData.partition();
        if (topicId == null) {
            this.log.error("Request topic id is null.");
            return Optional.of(ReadShareGroupStateSummaryResponse.toErrorResponseData(null, (int)partitionId, (Errors)Errors.INVALID_REQUEST, (String)NULL_TOPIC_ID.getMessage()));
        }
        if (partitionId < 0) {
            this.log.error("Request partition id is negative.");
            return Optional.of(ReadShareGroupStateSummaryResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.INVALID_REQUEST, (String)NEGATIVE_PARTITION_ID.getMessage()));
        }
        if (this.metadataImage == null) {
            this.log.error("Metadata image is null");
            return Optional.of(ReadShareGroupStateSummaryResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.UNKNOWN_TOPIC_OR_PARTITION, (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message()));
        }
        if (this.metadataImage.topics().getTopic(topicId) == null || this.metadataImage.topics().getPartition(topicId, partitionId) == null) {
            this.log.error("Topic/TopicPartition not found in metadata image.");
            return Optional.of(ReadShareGroupStateSummaryResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)Errors.UNKNOWN_TOPIC_OR_PARTITION, (String)Errors.UNKNOWN_TOPIC_OR_PARTITION.message()));
        }
        return Optional.empty();
    }

    private Optional<CoordinatorResult<DeleteShareGroupStateResponseData, CoordinatorRecord>> maybeGetDeleteStateError(DeleteShareGroupStateRequestData request) {
        DeleteShareGroupStateRequestData.DeleteStateData topicData = (DeleteShareGroupStateRequestData.DeleteStateData)request.topics().get(0);
        DeleteShareGroupStateRequestData.PartitionData partitionData = (DeleteShareGroupStateRequestData.PartitionData)topicData.partitions().get(0);
        Uuid topicId = topicData.topicId();
        int partitionId = partitionData.partition();
        if (topicId == null) {
            return Optional.of(this.getDeleteErrorCoordinatorResult(Errors.INVALID_REQUEST, NULL_TOPIC_ID, null, partitionId));
        }
        if (partitionId < 0) {
            return Optional.of(this.getDeleteErrorCoordinatorResult(Errors.INVALID_REQUEST, NEGATIVE_PARTITION_ID, topicId, partitionId));
        }
        if (this.metadataImage == null) {
            this.log.error("Metadata image is null");
            return Optional.of(this.getDeleteErrorCoordinatorResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, null, topicId, partitionId));
        }
        if (this.metadataImage.topics().getTopic(topicId) == null || this.metadataImage.topics().getPartition(topicId, partitionId) == null) {
            this.log.error("Topic/TopicPartition not found in metadata image.");
            return Optional.of(this.getDeleteErrorCoordinatorResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, null, topicId, partitionId));
        }
        return Optional.empty();
    }

    private Optional<CoordinatorResult<InitializeShareGroupStateResponseData, CoordinatorRecord>> maybeGetInitializeStateError(InitializeShareGroupStateRequestData request) {
        InitializeShareGroupStateRequestData.InitializeStateData topicData = (InitializeShareGroupStateRequestData.InitializeStateData)request.topics().get(0);
        InitializeShareGroupStateRequestData.PartitionData partitionData = (InitializeShareGroupStateRequestData.PartitionData)topicData.partitions().get(0);
        Uuid topicId = topicData.topicId();
        int partitionId = partitionData.partition();
        if (topicId == null) {
            return Optional.of(this.getInitializeErrorCoordinatorResult(Errors.INVALID_REQUEST, NULL_TOPIC_ID, null, partitionId));
        }
        if (partitionId < 0) {
            return Optional.of(this.getInitializeErrorCoordinatorResult(Errors.INVALID_REQUEST, NEGATIVE_PARTITION_ID, topicId, partitionId));
        }
        SharePartitionKey key = SharePartitionKey.getInstance((String)request.groupId(), (Uuid)topicId, (int)partitionId);
        if (partitionData.stateEpoch() != -1 && this.stateEpochMap.containsKey((Object)key) && (Integer)this.stateEpochMap.get((Object)key) > partitionData.stateEpoch()) {
            this.log.info("Initialize request state epoch is smaller than last recorded current: {}, requested: {}.", this.stateEpochMap.get((Object)key), (Object)partitionData.stateEpoch());
            return Optional.of(this.getInitializeErrorCoordinatorResult(Errors.FENCED_STATE_EPOCH, (Exception)Errors.FENCED_STATE_EPOCH.exception(), topicId, partitionId));
        }
        if (this.metadataImage == null) {
            this.log.error("Metadata image is null");
            return Optional.of(this.getInitializeErrorCoordinatorResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, null, topicId, partitionId));
        }
        if (this.metadataImage.topics().getTopic(topicId) == null || this.metadataImage.topics().getPartition(topicId, partitionId) == null) {
            this.log.error("Topic/TopicPartition not found in metadata image.");
            return Optional.of(this.getInitializeErrorCoordinatorResult(Errors.UNKNOWN_TOPIC_OR_PARTITION, null, topicId, partitionId));
        }
        return Optional.empty();
    }

    private CoordinatorResult<WriteShareGroupStateResponseData, CoordinatorRecord> getWriteErrorCoordinatorResult(Errors error, Exception exception, Uuid topicId, int partitionId) {
        String message = exception == null ? error.message() : exception.getMessage();
        WriteShareGroupStateResponseData responseData = WriteShareGroupStateResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)error, (String)message);
        return new CoordinatorResult(List.of(), (Object)responseData);
    }

    private CoordinatorResult<DeleteShareGroupStateResponseData, CoordinatorRecord> getDeleteErrorCoordinatorResult(Errors error, Exception exception, Uuid topicId, int partitionId) {
        String message = exception == null ? error.message() : exception.getMessage();
        DeleteShareGroupStateResponseData responseData = DeleteShareGroupStateResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)error, (String)message);
        return new CoordinatorResult(List.of(), (Object)responseData);
    }

    private CoordinatorResult<InitializeShareGroupStateResponseData, CoordinatorRecord> getInitializeErrorCoordinatorResult(Errors error, Exception exception, Uuid topicId, int partitionId) {
        String message = exception == null ? error.message() : exception.getMessage();
        InitializeShareGroupStateResponseData responseData = InitializeShareGroupStateResponse.toErrorResponseData((Uuid)topicId, (int)partitionId, (Errors)error, (String)message);
        return new CoordinatorResult(List.of(), (Object)responseData);
    }

    Integer getLeaderMapValue(SharePartitionKey key) {
        return (Integer)this.leaderEpochMap.get((Object)key);
    }

    Integer getStateEpochMapValue(SharePartitionKey key) {
        return (Integer)this.stateEpochMap.get((Object)key);
    }

    ShareGroupOffset getShareStateMapValue(SharePartitionKey key) {
        return (ShareGroupOffset)this.shareStateMap.get((Object)key);
    }

    CoordinatorMetricsShard getMetricsShard() {
        return this.metricsShard;
    }

    private static ShareGroupOffset merge(ShareGroupOffset soFar, ShareUpdateValue newData) {
        List<PersisterStateBatch> currentBatches = soFar.stateBatches();
        long newStartOffset = newData.startOffset() == -1L ? soFar.startOffset() : newData.startOffset();
        int newLeaderEpoch = newData.leaderEpoch() == -1 ? soFar.leaderEpoch() : newData.leaderEpoch();
        return new ShareGroupOffset.Builder().setSnapshotEpoch(soFar.snapshotEpoch()).setStateEpoch(soFar.stateEpoch()).setStartOffset(newStartOffset).setLeaderEpoch(newLeaderEpoch).setStateBatches(new PersisterStateBatchCombiner(currentBatches, newData.stateBatches().stream().map(ShareCoordinatorShard::toPersisterStateBatch).toList(), newStartOffset).combineStateBatches()).setCreateTimestamp(soFar.createTimestamp()).setWriteTimestamp(soFar.writeTimestamp()).build();
    }

    private static ApiMessage messageOrNull(ApiMessageAndVersion apiMessageAndVersion) {
        if (apiMessageAndVersion == null) {
            return null;
        }
        return apiMessageAndVersion.message();
    }

    private static PersisterStateBatch toPersisterStateBatch(ShareUpdateValue.StateBatch batch) {
        return new PersisterStateBatch(batch.firstOffset(), batch.lastOffset(), batch.deliveryState(), batch.deliveryCount());
    }

    public static class Builder
    implements CoordinatorShardBuilder<ShareCoordinatorShard, CoordinatorRecord> {
        private final ShareCoordinatorConfig config;
        private LogContext logContext;
        private SnapshotRegistry snapshotRegistry;
        private CoordinatorMetrics coordinatorMetrics;
        private TopicPartition topicPartition;
        private Time time;

        public Builder(ShareCoordinatorConfig config) {
            this.config = config;
        }

        public CoordinatorShardBuilder<ShareCoordinatorShard, CoordinatorRecord> withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        public CoordinatorShardBuilder<ShareCoordinatorShard, CoordinatorRecord> withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        public CoordinatorShardBuilder<ShareCoordinatorShard, CoordinatorRecord> withTime(Time time) {
            this.time = time;
            return this;
        }

        public CoordinatorShardBuilder<ShareCoordinatorShard, CoordinatorRecord> withTimer(CoordinatorTimer<Void, CoordinatorRecord> timer) {
            return this;
        }

        public CoordinatorShardBuilder<ShareCoordinatorShard, CoordinatorRecord> withExecutor(CoordinatorExecutor<CoordinatorRecord> executor) {
            return this;
        }

        public CoordinatorShardBuilder<ShareCoordinatorShard, CoordinatorRecord> withCoordinatorMetrics(CoordinatorMetrics coordinatorMetrics) {
            this.coordinatorMetrics = coordinatorMetrics;
            return this;
        }

        public CoordinatorShardBuilder<ShareCoordinatorShard, CoordinatorRecord> withTopicPartition(TopicPartition topicPartition) {
            this.topicPartition = topicPartition;
            return this;
        }

        public ShareCoordinatorShard build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.config == null) {
                throw new IllegalArgumentException("Config must be set.");
            }
            if (this.snapshotRegistry == null) {
                throw new IllegalArgumentException("SnapshotRegistry must be set.");
            }
            if (this.coordinatorMetrics == null || !(this.coordinatorMetrics instanceof ShareCoordinatorMetrics)) {
                throw new IllegalArgumentException("CoordinatorMetrics must be set and be of type ShareCoordinatorMetrics.");
            }
            if (this.topicPartition == null) {
                throw new IllegalArgumentException("TopicPartition must be set.");
            }
            ShareCoordinatorMetricsShard metricsShard = ((ShareCoordinatorMetrics)this.coordinatorMetrics).newMetricsShard(this.snapshotRegistry, this.topicPartition);
            return new ShareCoordinatorShard(this.logContext, this.config, this.coordinatorMetrics, metricsShard, this.snapshotRegistry, this.time);
        }
    }
}

