/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class BrokerRegistrationChangeRecord
implements ApiMessage {
    int brokerId;
    long brokerEpoch;
    byte fenced;
    byte inControlledShutdown;
    List<Uuid> logDirs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("fenced", (Type)Type.INT8, "-1 if the broker has been unfenced, 0 if no change, 1 if the broker has been fenced.")})});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("fenced", (Type)Type.INT8, "-1 if the broker has been unfenced, 0 if no change, 1 if the broker has been fenced."), 1, new Field("in_controlled_shutdown", (Type)Type.INT8, "0 if no change, 1 if the broker is in controlled shutdown.")})});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("broker_id", (Type)Type.INT32, "The broker id."), new Field("broker_epoch", (Type)Type.INT64, "The broker epoch assigned by the controller."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("fenced", (Type)Type.INT8, "-1 if the broker has been unfenced, 0 if no change, 1 if the broker has been fenced."), 1, new Field("in_controlled_shutdown", (Type)Type.INT8, "0 if no change, 1 if the broker is in controlled shutdown."), 2, new Field("log_dirs", (Type)new CompactArrayOf((Type)Type.UUID), "Log directories configured in this broker which are available.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public BrokerRegistrationChangeRecord(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public BrokerRegistrationChangeRecord() {
        this.brokerId = 0;
        this.brokerEpoch = 0L;
        this.fenced = 0;
        this.inControlledShutdown = 0;
        this.logDirs = new ArrayList<Uuid>(0);
    }

    public short apiKey() {
        return 17;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public final void read(Readable _readable, short _version) {
        this.brokerId = _readable.readInt();
        this.brokerEpoch = _readable.readLong();
        this.fenced = 0;
        this.inControlledShutdown = 0;
        this.logDirs = new ArrayList<Uuid>(0);
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                case 0: {
                    this.fenced = _readable.readByte();
                    continue block5;
                }
                case 1: {
                    if (_version >= 1) {
                        this.inControlledShutdown = _readable.readByte();
                        continue block5;
                    }
                    throw new RuntimeException("Tag 1 is not valid for version " + _version);
                }
                case 2: {
                    if (_version >= 2) {
                        int arrayLength = _readable.readUnsignedVarint() - 1;
                        if (arrayLength < 0) {
                            throw new RuntimeException("non-nullable field logDirs was serialized as null");
                        }
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Uuid> newCollection = new ArrayList<Uuid>(arrayLength);
                        for (int i = 0; i < arrayLength; ++i) {
                            newCollection.add(_readable.readUuid());
                        }
                        this.logDirs = newCollection;
                        continue block5;
                    }
                    throw new RuntimeException("Tag 2 is not valid for version " + _version);
                }
                default: {
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.brokerId);
        _writable.writeLong(this.brokerEpoch);
        if (this.fenced != 0) {
            ++_numTaggedFields;
        }
        if (_version >= 1) {
            if (this.inControlledShutdown != 0) {
                ++_numTaggedFields;
            }
        } else if (this.inControlledShutdown != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default inControlledShutdown at version " + _version);
        }
        if (_version >= 2) {
            if (!this.logDirs.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.logDirs.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default logDirs at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        if (this.fenced != 0) {
            _writable.writeUnsignedVarint(0);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.fenced);
        }
        if (_version >= 1 && this.inControlledShutdown != 0) {
            _writable.writeUnsignedVarint(1);
            _writable.writeUnsignedVarint(1);
            _writable.writeByte(this.inControlledShutdown);
        }
        if (_version >= 2 && !this.logDirs.isEmpty()) {
            _writable.writeUnsignedVarint(2);
            _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.logDirs).intValue());
            _writable.writeUnsignedVarint(this.logDirs.size() + 1);
            for (Uuid logDirsElement : this.logDirs) {
                _writable.writeUuid(logDirsElement);
            }
        }
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(8);
        if (this.fenced != 0) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (_version >= 1 && this.inControlledShutdown != 0) {
            ++_numTaggedFields;
            _size.addBytes(1);
            _size.addBytes(1);
            _size.addBytes(1);
        }
        if (_version >= 2 && !this.logDirs.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.logDirs.size() + 1)));
            _size.addBytes(this.logDirs.size() * 16);
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.logDirs, Integer.valueOf(_arraySize));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrokerRegistrationChangeRecord)) {
            return false;
        }
        BrokerRegistrationChangeRecord other = (BrokerRegistrationChangeRecord)obj;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        if (this.brokerEpoch != other.brokerEpoch) {
            return false;
        }
        if (this.fenced != other.fenced) {
            return false;
        }
        if (this.inControlledShutdown != other.inControlledShutdown) {
            return false;
        }
        if (this.logDirs == null ? other.logDirs != null : !this.logDirs.equals(other.logDirs)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        hashCode = 31 * hashCode + this.fenced;
        hashCode = 31 * hashCode + this.inControlledShutdown;
        hashCode = 31 * hashCode + (this.logDirs == null ? 0 : this.logDirs.hashCode());
        return hashCode;
    }

    public BrokerRegistrationChangeRecord duplicate() {
        BrokerRegistrationChangeRecord _duplicate = new BrokerRegistrationChangeRecord();
        _duplicate.brokerId = this.brokerId;
        _duplicate.brokerEpoch = this.brokerEpoch;
        _duplicate.fenced = this.fenced;
        _duplicate.inControlledShutdown = this.inControlledShutdown;
        ArrayList<Uuid> newLogDirs = new ArrayList<Uuid>(this.logDirs.size());
        for (Uuid _element : this.logDirs) {
            newLogDirs.add(_element);
        }
        _duplicate.logDirs = newLogDirs;
        return _duplicate;
    }

    public String toString() {
        return "BrokerRegistrationChangeRecord(brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ", fenced=" + this.fenced + ", inControlledShutdown=" + this.inControlledShutdown + ", logDirs=" + MessageUtil.deepToString(this.logDirs.iterator()) + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public byte fenced() {
        return this.fenced;
    }

    public byte inControlledShutdown() {
        return this.inControlledShutdown;
    }

    public List<Uuid> logDirs() {
        return this.logDirs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public BrokerRegistrationChangeRecord setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setFenced(byte v) {
        this.fenced = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setInControlledShutdown(byte v) {
        this.inControlledShutdown = v;
        return this;
    }

    public BrokerRegistrationChangeRecord setLogDirs(List<Uuid> v) {
        this.logDirs = v;
        return this;
    }
}

