/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.orcid.OrcidProfileDefinition;
import org.pac4j.scribe.builder.api.OrcidApi20;

public class OrcidClient
extends OAuth20Client {
    protected static final String DEFAULT_SCOPE = "/authenticate";

    public OrcidClient() {
        this.setScope(DEFAULT_SCOPE);
    }

    public OrcidClient(String key, String secret) {
        this.setScope(DEFAULT_SCOPE);
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void clientInit() {
        this.configuration.setApi(new OrcidApi20());
        this.configuration.setProfileDefinition(new OrcidProfileDefinition());
        this.configuration.setTokenAsHeader(true);
        this.configuration.setHasBeenCancelledFactory(ctx -> {
            String error = ctx.getRequestParameter("error").orElse(null);
            String errorDescription = ctx.getRequestParameter("error_description").orElse(null);
            if ("access_denied".equals(error) && "User denied access".equals(errorDescription)) {
                return true;
            }
            return false;
        });
        super.clientInit();
    }

    public String getScope() {
        return this.getConfiguration().getScope();
    }

    public void setScope(String scope) {
        this.getConfiguration().setScope(scope);
    }
}

