/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.protocol.GetCallbackWrapper;

public class ProxyCallback
implements GetOperation.Callback {
    private final Map<String, Collection<GetOperation.Callback>> callbacks = new HashMap<String, Collection<GetOperation.Callback>>();
    private final Collection<GetOperation.Callback> allCallbacks = new ArrayList<GetOperation.Callback>();

    public void addCallbacks(GetOperation o) {
        GetCallbackWrapper c = new GetCallbackWrapper(o.getKeys().size(), (GetOperation.Callback)o.getCallback());
        this.allCallbacks.add(c);
        for (String s : o.getKeys()) {
            Collection<GetOperation.Callback> cbs = this.callbacks.get(s);
            if (cbs == null) {
                cbs = new ArrayList<GetOperation.Callback>();
                this.callbacks.put(s, cbs);
            }
            cbs.add(c);
        }
    }

    @Override
    public void gotData(String key, int flags, byte[] data) {
        Collection<GetOperation.Callback> cbs = this.callbacks.get(key);
        assert (cbs != null) : "No callbacks for key " + key;
        for (GetOperation.Callback c : cbs) {
            c.gotData(key, flags, data);
        }
    }

    @Override
    public void receivedStatus(OperationStatus status) {
        for (GetOperation.Callback c : this.allCallbacks) {
            c.receivedStatus(status);
        }
    }

    @Override
    public void complete() {
        for (GetOperation.Callback c : this.allCallbacks) {
            c.complete();
        }
    }

    public int numKeys() {
        return this.callbacks.size();
    }

    public int numCallbacks() {
        return this.allCallbacks.size();
    }
}

