/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway;

import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.cookie.Cookie;
import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway")
public interface SpiGatewayMessages {
    @Message(level=MessageLevel.DEBUG, text="Dispatch request: {0} {1}")
    public void dispatchRequest(String var1, URI var2);

    @Message(level=MessageLevel.WARN, text="Connection exception dispatching request: {0} {1}")
    public void dispatchServiceConnectionException(URI var1, @StackTrace(level=MessageLevel.WARN) Exception var2);

    @Message(level=MessageLevel.DEBUG, text="Dispatch response status: {0}")
    public void dispatchResponseStatusCode(int var1);

    @Message(level=MessageLevel.DEBUG, text="Dispatch response status: {0}, Location: {1}")
    public void dispatchResponseCreatedStatusCode(int var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Successful Knox->Hadoop SPNegotiation authentication for URL: {0}")
    public void successfulSPNegoAuthn(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed Knox->Hadoop SPNegotiation authentication for URL: {0}")
    public void failedSPNegoAuthn(String var1);

    @Message(level=MessageLevel.WARN, text="Error occurred when closing HTTP client : {0}")
    public void errorClosingHttpClient(@StackTrace(level=MessageLevel.WARN) Exception var1);

    @Message(level=MessageLevel.WARN, text="Skipping unencodable parameter {0}={1}, {2}: {3}")
    public void skippingUnencodableParameter(String var1, String var2, String var3, @StackTrace(level=MessageLevel.DEBUG) Exception var4);

    @Message(level=MessageLevel.DEBUG, text="Using default character set {1} for entity of type {0}")
    public void usingDefaultCharsetForEntity(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Using explicit character set {1} for entity of type {0}")
    public void usingExplicitCharsetForEntity(String var1, Charset var2);

    @Message(level=MessageLevel.DEBUG, text="Inbound response entity content type not provided.")
    public void unknownResponseEntityContentType();

    @Message(level=MessageLevel.DEBUG, text="Inbound response entity content type: {0}")
    public void inboundResponseEntityContentType(String var1);

    @Message(level=MessageLevel.WARN, text="Possible identity spoofing attempt - impersonation parameter removed: {0}")
    public void possibleIdentitySpoofingAttempt(String var1);

    @Message(level=MessageLevel.WARN, text="Error ocurred while accessing params in query string: {0}")
    public void unableToGetParamsFromQueryString(@StackTrace(level=MessageLevel.WARN) Exception var1);

    @Message(level=MessageLevel.DEBUG, text="Accepting service cookie: {0}")
    public void acceptingServiceCookie(Cookie var1);

    @Message(level=MessageLevel.ERROR, text="Error reading Kerberos login configuration {0} : {1}")
    public void errorReadingKerberosLoginConfig(String var1, @StackTrace(level=MessageLevel.ERROR) Exception var2);

    @Message(level=MessageLevel.INFO, text="Applying a derived dispatch whitelist because none is configured in gateway-site: {0}")
    public void derivedDispatchWhitelist(String var1);

    @Message(level=MessageLevel.ERROR, text="Unable to reliably determine the Knox domain for the default whitelist. Defaulting to allow requests only to {0}. Please consider explicitly configuring the whitelist via the gateway.dispatch.whitelist property in gateway-site")
    public void unableToDetermineKnoxDomainForDefaultWhitelist(String var1);

    @Message(level=MessageLevel.ERROR, text="The dispatch to {0} was disallowed because it fails the dispatch whitelist validation. See documentation for dispatch whitelisting.")
    public void dispatchDisallowed(String var1);

    @Message(level=MessageLevel.DEBUG, text="HTTP client connection timeout is set to {0} for {1}")
    public void setHttpClientConnectionTimeout(int var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="HTTP client socket timeout is set to {0} for {1}")
    public void setHttpClientSocketTimeout(int var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="replayBufferSize is set to {0} for {1}")
    public void setReplayBufferSize(int var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Using two way SSL in {0}")
    public void usingTwoWaySsl(String var1);

    @Message(level=MessageLevel.DEBUG, text="Adding outbound header {0} and value {1}")
    public void addedOutboundheader(String var1, String var2);

    @Message(level=MessageLevel.DEBUG, text="Skipped adding outbound header {0} and value {1}")
    public void skippedOutboundHeader(String var1, String var2);
}

