/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiAuthRoleRef;
import com.cloudera.api.swagger.model.ApiExternalUserMappingType;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This is the model for external user mapping information in the API, v19 and beyond. These can be of 4 types : LDAP group, SAML, SAML attribute and External Script. <p>")
public class ApiExternalUserMapping {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="type")
    private ApiExternalUserMappingType type = null;
    @SerializedName(value="uuid")
    private String uuid = null;
    @SerializedName(value="authRoles")
    private List<ApiAuthRoleRef> authRoles = null;

    public ApiExternalUserMapping name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the external mapping")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiExternalUserMapping type(ApiExternalUserMappingType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the external mapping")
    public ApiExternalUserMappingType getType() {
        return this.type;
    }

    public void setType(ApiExternalUserMappingType type) {
        this.type = type;
    }

    public ApiExternalUserMapping uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @ApiModelProperty(value="Readonly. The UUID of the authRole. <p>")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ApiExternalUserMapping authRoles(List<ApiAuthRoleRef> authRoles) {
        this.authRoles = authRoles;
        return this;
    }

    public ApiExternalUserMapping addAuthRolesItem(ApiAuthRoleRef authRolesItem) {
        if (this.authRoles == null) {
            this.authRoles = new ArrayList<ApiAuthRoleRef>();
        }
        this.authRoles.add(authRolesItem);
        return this;
    }

    @ApiModelProperty(value="A list of ApiAuthRole that this user possesses.  Each custom role with be a built-in role with a set of scopes. ApiAuthRole is the model for specifying custom roles. Only admins and user admins can create/delete/update external user mappings.")
    public List<ApiAuthRoleRef> getAuthRoles() {
        return this.authRoles;
    }

    public void setAuthRoles(List<ApiAuthRoleRef> authRoles) {
        this.authRoles = authRoles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiExternalUserMapping apiExternalUserMapping = (ApiExternalUserMapping)o;
        return Objects.equals(this.name, apiExternalUserMapping.name) && Objects.equals((Object)this.type, (Object)apiExternalUserMapping.type) && Objects.equals(this.uuid, apiExternalUserMapping.uuid) && Objects.equals(this.authRoles, apiExternalUserMapping.authRoles);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.uuid, this.authRoles});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiExternalUserMapping {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    authRoles: ").append(this.toIndentedString(this.authRoles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

