/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.yarn;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.yarn.ResourceManagerServiceModelGeneratorBase;

public class JobTrackerServiceModelGenerator
extends ResourceManagerServiceModelGeneratorBase {
    private static final String SERVICE = "JOBTRACKER";
    private static final String RM_PORT = "yarn_resourcemanager_address";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) throws ApiException {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, RM_PORT);
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "rpc://%s:%s", hostname, port));
        model.addRoleProperty(this.getRoleType(), RM_PORT, port);
        return model;
    }
}

