/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.admin;

import io.swagger.annotations.Api;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.apache.knox.gateway.service.definition.ServiceDefinitionPair;
import org.apache.knox.gateway.service.definition.ServiceDefinitionPairComparator;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.registry.ServiceDefinitionRegistry;
import org.apache.knox.gateway.services.registry.ServiceDefinitionRegistryException;

@Api(value="serviceDefinition", description="The Knox Admin API to interact with service definition information.")
@Path(value="/api/v1")
@Singleton
public class ServiceDefinitionsResource {
    private static final String ERROR_CODE_CREATION = "CREATION_ERROR";
    private static final String ERROR_CODE_CREATION_OR_UPDATE = "CREATION_OR_UPDATE_ERROR";
    private static final String ERROR_CODE_DELETION = "DELETION_ERROR";
    @Context
    private HttpServletRequest request;
    private ServiceDefinitionRegistry serviceDefinitionRegistry;

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="servicedefinitions")
    public ServiceDefinitionsWrapper getServiceDefinitions(@QueryParam(value="serviceOnly") @DefaultValue(value="false") boolean serviceOnly) {
        return this.getServiceDefinitions(null, serviceOnly);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="servicedefinitions/{name}")
    public ServiceDefinitionsWrapper getServiceDefinition(@PathParam(value="name") String name, @QueryParam(value="serviceOnly") @DefaultValue(value="false") boolean serviceOnly) {
        return this.getServiceDefinitions(serviceDefinitionPair -> serviceDefinitionPair.getService().getName().equalsIgnoreCase(name), serviceOnly);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="servicedefinitions/{name}/{role}")
    public ServiceDefinitionsWrapper getServiceDefinition(@PathParam(value="name") String name, @PathParam(value="role") String role, @QueryParam(value="serviceOnly") @DefaultValue(value="false") boolean serviceOnly) {
        return this.getServiceDefinitions(serviceDefinitionPair -> serviceDefinitionPair.getService().getName().equalsIgnoreCase(name) && serviceDefinitionPair.getService().getRole().equalsIgnoreCase(role), serviceOnly);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="servicedefinitions/{name}/{role}/{version}")
    public ServiceDefinitionsWrapper getServiceDefinition(@PathParam(value="name") String name, @PathParam(value="role") String role, @PathParam(value="version") String version, @QueryParam(value="serviceOnly") @DefaultValue(value="false") boolean serviceOnly) {
        return this.getServiceDefinitions(serviceDefinitionPair -> serviceDefinitionPair.getService().getName().equalsIgnoreCase(name) && serviceDefinitionPair.getService().getRole().equalsIgnoreCase(role) && serviceDefinitionPair.getService().getVersion().equalsIgnoreCase(version), serviceOnly);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="servicedefinitions")
    public Response saveServiceDefinition(ServiceDefinitionPair serviceDefinition) {
        try {
            this.getServiceDefinitionRegistry().saveServiceDefinition(serviceDefinition);
            return Response.created((URI)this.toUri(serviceDefinition)).build();
        }
        catch (URISyntaxException | ServiceDefinitionRegistryException e) {
            return Response.serverError().entity((Object)("{ \"CREATION_ERROR\": \"" + e.getMessage() + "\" }")).build();
        }
    }

    @PUT
    @Consumes(value={"application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="servicedefinitions")
    public Response saveOrUpdateServiceDefinition(ServiceDefinitionPair serviceDefinition) {
        try {
            this.getServiceDefinitionRegistry().saveOrUpdateServiceDefinition(serviceDefinition);
            return Response.created((URI)this.toUri(serviceDefinition)).build();
        }
        catch (URISyntaxException | ServiceDefinitionRegistryException e) {
            return Response.serverError().entity((Object)("{ \"CREATION_OR_UPDATE_ERROR\": \"" + e.getMessage() + "\" }")).build();
        }
    }

    @DELETE
    @Produces(value={"application/json", "application/xml"})
    @Path(value="servicedefinitions/{name}/{role}/{version}")
    public Response deleteServiceDefinition(@PathParam(value="name") String name, @PathParam(value="role") String role, @PathParam(value="version") String version) {
        try {
            this.getServiceDefinitionRegistry().deleteServiceDefinition(name, role, version);
            return Response.ok().location(this.toUri(name, role, version)).build();
        }
        catch (URISyntaxException | ServiceDefinitionRegistryException e) {
            return Response.serverError().entity((Object)("{ \"DELETION_ERROR\": \"" + e.getMessage() + "\" }")).build();
        }
    }

    private URI toUri(ServiceDefinitionPair serviceDefinition) throws URISyntaxException {
        return this.toUri(serviceDefinition.getService().getName(), serviceDefinition.getService().getRole(), serviceDefinition.getService().getVersion());
    }

    private URI toUri(String name, String role, String version) throws URISyntaxException {
        return new URI("api/v1/servicedefinitions/" + name + "/" + role + "/" + version);
    }

    private ServiceDefinitionsWrapper getServiceDefinitions(Predicate<? super ServiceDefinitionPair> predicate, boolean serviceOnly) {
        Set<ServiceDefinitionPair> serviceDefinitions = this.getServiceDefinitions(predicate);
        ServiceDefinitionsWrapper serviceDefinitionsWrapper = new ServiceDefinitionsWrapper();
        if (serviceOnly) {
            serviceDefinitions.stream().forEach(serviceDefinition -> serviceDefinitionsWrapper.getServiceDefinitions().add(new ServiceDefinitionPair(serviceDefinition.getService(), null)));
        } else {
            serviceDefinitionsWrapper.setServiceDefinitions(serviceDefinitions);
        }
        return serviceDefinitionsWrapper;
    }

    private Set<ServiceDefinitionPair> getServiceDefinitions(Predicate<? super ServiceDefinitionPair> predicate) {
        Set serviceDefinitions = this.getServiceDefinitionRegistry().getServiceDefinitions();
        return predicate == null ? serviceDefinitions : serviceDefinitions.stream().filter(predicate).collect(Collectors.toSet());
    }

    private ServiceDefinitionRegistry getServiceDefinitionRegistry() {
        if (this.serviceDefinitionRegistry == null) {
            GatewayServices gatewayServices = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
            this.serviceDefinitionRegistry = (ServiceDefinitionRegistry)gatewayServices.getService(ServiceType.SERVICE_DEFINITION_REGISTRY);
        }
        return this.serviceDefinitionRegistry;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    public static class ServiceDefinitionsWrapper {
        @XmlElement(name="serviceDefinition")
        @XmlElementWrapper(name="serviceDefinitions")
        private Set<ServiceDefinitionPair> serviceDefinitions = new TreeSet<ServiceDefinitionPair>((Comparator<ServiceDefinitionPair>)new ServiceDefinitionPairComparator());

        public Set<ServiceDefinitionPair> getServiceDefinitions() {
            return this.serviceDefinitions;
        }

        public void setServiceDefinitions(Set<ServiceDefinitionPair> serviceDefinitions) {
            this.serviceDefinitions = serviceDefinitions;
        }
    }
}

