/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.monitor;

import java.io.File;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClientService;
import org.apache.knox.gateway.services.factory.AbstractServiceFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitor;
import org.apache.knox.gateway.topology.monitor.ZkRemoteConfigurationMonitorService;
import org.apache.knox.gateway.topology.monitor.db.DbRemoteConfigurationMonitorService;
import org.apache.knox.gateway.topology.monitor.db.LocalDirectory;
import org.apache.knox.gateway.topology.monitor.db.RemoteConfigDatabase;
import org.apache.knox.gateway.util.JDBCUtils;

public class RemoteConfigurationMonitorServiceFactory
extends AbstractServiceFactory {
    private static final String DEFAULT_IMPLEMENTATION = ZkRemoteConfigurationMonitorService.class.getName();

    protected RemoteConfigurationMonitor createService(GatewayServices gatewayServices, ServiceType serviceType, GatewayConfig gatewayConfig, Map<String, String> options, String implementation) throws ServiceLifecycleException {
        Object service = null;
        if (StringUtils.isBlank((CharSequence)implementation) && gatewayConfig.getRemoteConfigurationMonitorClientName() != null) {
            implementation = DEFAULT_IMPLEMENTATION;
        }
        if (this.matchesImplementation(implementation, ZkRemoteConfigurationMonitorService.class)) {
            service = new ZkRemoteConfigurationMonitorService(gatewayConfig, (RemoteConfigurationRegistryClientService)gatewayServices.getService(ServiceType.REMOTE_REGISTRY_CLIENT_SERVICE));
        } else if (this.matchesImplementation(implementation, DbRemoteConfigurationMonitorService.class)) {
            service = this.createDbBasedMonitor(gatewayConfig, this.getAliasService(gatewayServices));
        }
        return service;
    }

    private DbRemoteConfigurationMonitorService createDbBasedMonitor(GatewayConfig config, AliasService aliasService) throws ServiceLifecycleException {
        try {
            RemoteConfigDatabase db = new RemoteConfigDatabase(JDBCUtils.getDataSource(config, aliasService));
            LocalDirectory descriptorDir = new LocalDirectory(new File(config.getGatewayDescriptorsDir()));
            LocalDirectory providerDir = new LocalDirectory(new File(config.getGatewayProvidersConfigDir()));
            return new DbRemoteConfigurationMonitorService(db, providerDir, descriptorDir, config.getDbRemoteConfigMonitorPollingInterval(), config.getDbRemoteConfigMonitorCleanUpInterval());
        }
        catch (SQLException | AliasServiceException e) {
            throw new ServiceLifecycleException("Cannot create DbRemoteConfigurationMonitor", (Exception)e);
        }
    }

    @Override
    protected ServiceType getServiceType() {
        return ServiceType.REMOTE_CONFIGURATION_MONITOR;
    }

    @Override
    protected Collection<String> getKnownImplementations() {
        return Arrays.asList(DEFAULT_IMPLEMENTATION, DbRemoteConfigurationMonitorService.class.getName());
    }
}

