/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.tool.xmlsectool;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import net.shibboleth.tool.xmlsectool.DigestChoice;

public class Blacklist {
    private final Set<String> digestBlacklist = new TreeSet<String>();
    private final Set<String> signatureBlacklist = new TreeSet<String>();

    public Blacklist() {
        this.addDigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#md5");
        this.addSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-md5");
        this.addDigest(DigestChoice.SHA1);
    }

    private void addDigestAlgorithm(String uri) {
        this.digestBlacklist.add(uri);
    }

    private void removeDigestAlgorithm(String uri) {
        this.digestBlacklist.remove(uri);
    }

    private void addSignatureAlgorithm(String uri) {
        this.signatureBlacklist.add(uri);
    }

    private void removeSignatureAlgorithm(String uri) {
        this.signatureBlacklist.remove(uri);
    }

    public void addDigest(DigestChoice digestChoice) {
        this.addDigestAlgorithm(digestChoice.getDigestAlgorithm());
        this.addSignatureAlgorithm(digestChoice.getRSAAlgorithm());
        this.addSignatureAlgorithm(digestChoice.getECDSAAlgorithm());
    }

    public void removeDigest(DigestChoice digestChoice) {
        this.removeDigestAlgorithm(digestChoice.getDigestAlgorithm());
        this.removeSignatureAlgorithm(digestChoice.getRSAAlgorithm());
        this.removeSignatureAlgorithm(digestChoice.getECDSAAlgorithm());
    }

    public boolean isBlacklistedDigest(String alg) {
        return this.digestBlacklist.contains(alg);
    }

    public boolean isBlacklistedSignature(String alg) {
        return this.signatureBlacklist.contains(alg);
    }

    public Collection<String> getDigestBlacklist() {
        return Collections.unmodifiableCollection(this.digestBlacklist);
    }

    public Collection<String> getSignatureBlacklist() {
        return Collections.unmodifiableCollection(this.signatureBlacklist);
    }

    public void clear() {
        this.digestBlacklist.clear();
        this.signatureBlacklist.clear();
    }

    public void list(PrintStream out) {
        out.println("Digest algorithm blacklist:");
        if (this.getDigestBlacklist().isEmpty()) {
            out.println("   blacklist is empty");
        } else {
            for (String uri : this.getDigestBlacklist()) {
                out.println("   " + uri);
            }
        }
        out.println();
        out.println("Signature algorithm blacklist:");
        if (this.getSignatureBlacklist().isEmpty()) {
            out.println("   blacklist is empty");
        } else {
            for (String uri : this.getSignatureBlacklist()) {
                out.println("   " + uri);
            }
        }
        out.println();
    }
}

