/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiClusterTemplateConfig;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Role config group info.")
public class ApiClusterTemplateRoleConfigGroup {
    @SerializedName(value="refName")
    private String refName = null;
    @SerializedName(value="roleType")
    private String roleType = null;
    @SerializedName(value="base")
    private Boolean base = null;
    @SerializedName(value="displayName")
    private String displayName = null;
    @SerializedName(value="configs")
    private List<ApiClusterTemplateConfig> configs = null;

    public ApiClusterTemplateRoleConfigGroup refName(String refName) {
        this.refName = refName;
        return this;
    }

    @ApiModelProperty(value="The reference name of the role config.")
    public String getRefName() {
        return this.refName;
    }

    public void setRefName(String refName) {
        this.refName = refName;
    }

    public ApiClusterTemplateRoleConfigGroup roleType(String roleType) {
        this.roleType = roleType;
        return this;
    }

    @ApiModelProperty(value="Role type")
    public String getRoleType() {
        return this.roleType;
    }

    public void setRoleType(String roleType) {
        this.roleType = roleType;
    }

    public ApiClusterTemplateRoleConfigGroup base(Boolean base) {
        this.base = base;
        return this;
    }

    @ApiModelProperty(value="If true then it is the base config group for that role. There can only be one base role config group for a given role type. Defaults to false.")
    public Boolean getBase() {
        return this.base;
    }

    public void setBase(Boolean base) {
        this.base = base;
    }

    public ApiClusterTemplateRoleConfigGroup displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="Role config group display name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ApiClusterTemplateRoleConfigGroup configs(List<ApiClusterTemplateConfig> configs) {
        this.configs = configs;
        return this;
    }

    public ApiClusterTemplateRoleConfigGroup addConfigsItem(ApiClusterTemplateConfig configsItem) {
        if (this.configs == null) {
            this.configs = new ArrayList<ApiClusterTemplateConfig>();
        }
        this.configs.add(configsItem);
        return this;
    }

    @ApiModelProperty(value="List of configurations")
    public List<ApiClusterTemplateConfig> getConfigs() {
        return this.configs;
    }

    public void setConfigs(List<ApiClusterTemplateConfig> configs) {
        this.configs = configs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterTemplateRoleConfigGroup apiClusterTemplateRoleConfigGroup = (ApiClusterTemplateRoleConfigGroup)o;
        return Objects.equals(this.refName, apiClusterTemplateRoleConfigGroup.refName) && Objects.equals(this.roleType, apiClusterTemplateRoleConfigGroup.roleType) && Objects.equals(this.base, apiClusterTemplateRoleConfigGroup.base) && Objects.equals(this.displayName, apiClusterTemplateRoleConfigGroup.displayName) && Objects.equals(this.configs, apiClusterTemplateRoleConfigGroup.configs);
    }

    public int hashCode() {
        return Objects.hash(this.refName, this.roleType, this.base, this.displayName, this.configs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterTemplateRoleConfigGroup {\n");
        sb.append("    refName: ").append(this.toIndentedString(this.refName)).append("\n");
        sb.append("    roleType: ").append(this.toIndentedString(this.roleType)).append("\n");
        sb.append("    base: ").append(this.toIndentedString(this.base)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    configs: ").append(this.toIndentedString(this.configs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

