/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiImpalaUtilizationHistogram;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.Objects;

@ApiModel(description="Utilization report information of a tenant of Impala application.")
public class ApiImpalaTenantUtilization {
    @SerializedName(value="tenantName")
    private String tenantName = null;
    @SerializedName(value="totalQueries")
    private BigDecimal totalQueries = null;
    @SerializedName(value="successfulQueries")
    private BigDecimal successfulQueries = null;
    @SerializedName(value="oomQueries")
    private BigDecimal oomQueries = null;
    @SerializedName(value="timeOutQueries")
    private BigDecimal timeOutQueries = null;
    @SerializedName(value="rejectedQueries")
    private BigDecimal rejectedQueries = null;
    @SerializedName(value="avgWaitTimeInQueue")
    private BigDecimal avgWaitTimeInQueue = null;
    @SerializedName(value="peakAllocationTimestampMS")
    private BigDecimal peakAllocationTimestampMS = null;
    @SerializedName(value="maxAllocatedMemory")
    private BigDecimal maxAllocatedMemory = null;
    @SerializedName(value="maxAllocatedMemoryPercentage")
    private BigDecimal maxAllocatedMemoryPercentage = null;
    @SerializedName(value="utilizedAtMaxAllocated")
    private BigDecimal utilizedAtMaxAllocated = null;
    @SerializedName(value="utilizedAtMaxAllocatedPercentage")
    private BigDecimal utilizedAtMaxAllocatedPercentage = null;
    @SerializedName(value="peakUsageTimestampMS")
    private BigDecimal peakUsageTimestampMS = null;
    @SerializedName(value="maxUtilizedMemory")
    private BigDecimal maxUtilizedMemory = null;
    @SerializedName(value="maxUtilizedMemoryPercentage")
    private BigDecimal maxUtilizedMemoryPercentage = null;
    @SerializedName(value="allocatedAtMaxUtilized")
    private BigDecimal allocatedAtMaxUtilized = null;
    @SerializedName(value="allocatedAtMaxUtilizedPercentage")
    private BigDecimal allocatedAtMaxUtilizedPercentage = null;
    @SerializedName(value="distributionUtilizedByImpalaDaemon")
    private ApiImpalaUtilizationHistogram distributionUtilizedByImpalaDaemon = null;
    @SerializedName(value="distributionAllocatedByImpalaDaemon")
    private ApiImpalaUtilizationHistogram distributionAllocatedByImpalaDaemon = null;
    @SerializedName(value="avgSpilledMemory")
    private BigDecimal avgSpilledMemory = null;
    @SerializedName(value="maxSpilledMemory")
    private BigDecimal maxSpilledMemory = null;

    public ApiImpalaTenantUtilization tenantName(String tenantName) {
        this.tenantName = tenantName;
        return this;
    }

    @ApiModelProperty(value="Name of the tenant.")
    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public ApiImpalaTenantUtilization totalQueries(BigDecimal totalQueries) {
        this.totalQueries = totalQueries;
        return this;
    }

    @ApiModelProperty(value="Total number of queries submitted to Impala.")
    public BigDecimal getTotalQueries() {
        return this.totalQueries;
    }

    public void setTotalQueries(BigDecimal totalQueries) {
        this.totalQueries = totalQueries;
    }

    public ApiImpalaTenantUtilization successfulQueries(BigDecimal successfulQueries) {
        this.successfulQueries = successfulQueries;
        return this;
    }

    @ApiModelProperty(value="Number of queries that finished successfully.")
    public BigDecimal getSuccessfulQueries() {
        return this.successfulQueries;
    }

    public void setSuccessfulQueries(BigDecimal successfulQueries) {
        this.successfulQueries = successfulQueries;
    }

    public ApiImpalaTenantUtilization oomQueries(BigDecimal oomQueries) {
        this.oomQueries = oomQueries;
        return this;
    }

    @ApiModelProperty(value="Number of queries that failed due to insufficient memory.")
    public BigDecimal getOomQueries() {
        return this.oomQueries;
    }

    public void setOomQueries(BigDecimal oomQueries) {
        this.oomQueries = oomQueries;
    }

    public ApiImpalaTenantUtilization timeOutQueries(BigDecimal timeOutQueries) {
        this.timeOutQueries = timeOutQueries;
        return this;
    }

    @ApiModelProperty(value="Number of queries that timed out while waiting for resources in a pool.")
    public BigDecimal getTimeOutQueries() {
        return this.timeOutQueries;
    }

    public void setTimeOutQueries(BigDecimal timeOutQueries) {
        this.timeOutQueries = timeOutQueries;
    }

    public ApiImpalaTenantUtilization rejectedQueries(BigDecimal rejectedQueries) {
        this.rejectedQueries = rejectedQueries;
        return this;
    }

    @ApiModelProperty(value="Number of queries that were rejected by Impala because the pool was full.")
    public BigDecimal getRejectedQueries() {
        return this.rejectedQueries;
    }

    public void setRejectedQueries(BigDecimal rejectedQueries) {
        this.rejectedQueries = rejectedQueries;
    }

    public ApiImpalaTenantUtilization avgWaitTimeInQueue(BigDecimal avgWaitTimeInQueue) {
        this.avgWaitTimeInQueue = avgWaitTimeInQueue;
        return this;
    }

    @ApiModelProperty(value="Average time, in milliseconds, spent by a query in an Impala pool while waiting for resources.")
    public BigDecimal getAvgWaitTimeInQueue() {
        return this.avgWaitTimeInQueue;
    }

    public void setAvgWaitTimeInQueue(BigDecimal avgWaitTimeInQueue) {
        this.avgWaitTimeInQueue = avgWaitTimeInQueue;
    }

    public ApiImpalaTenantUtilization peakAllocationTimestampMS(BigDecimal peakAllocationTimestampMS) {
        this.peakAllocationTimestampMS = peakAllocationTimestampMS;
        return this;
    }

    @ApiModelProperty(value="The time when Impala reserved the maximum amount of memory for queries.")
    public BigDecimal getPeakAllocationTimestampMS() {
        return this.peakAllocationTimestampMS;
    }

    public void setPeakAllocationTimestampMS(BigDecimal peakAllocationTimestampMS) {
        this.peakAllocationTimestampMS = peakAllocationTimestampMS;
    }

    public ApiImpalaTenantUtilization maxAllocatedMemory(BigDecimal maxAllocatedMemory) {
        this.maxAllocatedMemory = maxAllocatedMemory;
        return this;
    }

    @ApiModelProperty(value="The maximum memory (in bytes) that was reserved by Impala for executing queries.")
    public BigDecimal getMaxAllocatedMemory() {
        return this.maxAllocatedMemory;
    }

    public void setMaxAllocatedMemory(BigDecimal maxAllocatedMemory) {
        this.maxAllocatedMemory = maxAllocatedMemory;
    }

    public ApiImpalaTenantUtilization maxAllocatedMemoryPercentage(BigDecimal maxAllocatedMemoryPercentage) {
        this.maxAllocatedMemoryPercentage = maxAllocatedMemoryPercentage;
        return this;
    }

    @ApiModelProperty(value="The maximum percentage of memory that was reserved by Impala for executing queries.")
    public BigDecimal getMaxAllocatedMemoryPercentage() {
        return this.maxAllocatedMemoryPercentage;
    }

    public void setMaxAllocatedMemoryPercentage(BigDecimal maxAllocatedMemoryPercentage) {
        this.maxAllocatedMemoryPercentage = maxAllocatedMemoryPercentage;
    }

    public ApiImpalaTenantUtilization utilizedAtMaxAllocated(BigDecimal utilizedAtMaxAllocated) {
        this.utilizedAtMaxAllocated = utilizedAtMaxAllocated;
        return this;
    }

    @ApiModelProperty(value="The amount of memory (in bytes) used by Impala for running queries at the time when maximum memory was reserved.")
    public BigDecimal getUtilizedAtMaxAllocated() {
        return this.utilizedAtMaxAllocated;
    }

    public void setUtilizedAtMaxAllocated(BigDecimal utilizedAtMaxAllocated) {
        this.utilizedAtMaxAllocated = utilizedAtMaxAllocated;
    }

    public ApiImpalaTenantUtilization utilizedAtMaxAllocatedPercentage(BigDecimal utilizedAtMaxAllocatedPercentage) {
        this.utilizedAtMaxAllocatedPercentage = utilizedAtMaxAllocatedPercentage;
        return this;
    }

    @ApiModelProperty(value="The percentage of memory used by Impala for running queries at the time when maximum memory was reserved.")
    public BigDecimal getUtilizedAtMaxAllocatedPercentage() {
        return this.utilizedAtMaxAllocatedPercentage;
    }

    public void setUtilizedAtMaxAllocatedPercentage(BigDecimal utilizedAtMaxAllocatedPercentage) {
        this.utilizedAtMaxAllocatedPercentage = utilizedAtMaxAllocatedPercentage;
    }

    public ApiImpalaTenantUtilization peakUsageTimestampMS(BigDecimal peakUsageTimestampMS) {
        this.peakUsageTimestampMS = peakUsageTimestampMS;
        return this;
    }

    @ApiModelProperty(value="The time when Impala used the maximum amount of memory for queries.")
    public BigDecimal getPeakUsageTimestampMS() {
        return this.peakUsageTimestampMS;
    }

    public void setPeakUsageTimestampMS(BigDecimal peakUsageTimestampMS) {
        this.peakUsageTimestampMS = peakUsageTimestampMS;
    }

    public ApiImpalaTenantUtilization maxUtilizedMemory(BigDecimal maxUtilizedMemory) {
        this.maxUtilizedMemory = maxUtilizedMemory;
        return this;
    }

    @ApiModelProperty(value="The maximum memory (in bytes) that was used by Impala for executing queries.")
    public BigDecimal getMaxUtilizedMemory() {
        return this.maxUtilizedMemory;
    }

    public void setMaxUtilizedMemory(BigDecimal maxUtilizedMemory) {
        this.maxUtilizedMemory = maxUtilizedMemory;
    }

    public ApiImpalaTenantUtilization maxUtilizedMemoryPercentage(BigDecimal maxUtilizedMemoryPercentage) {
        this.maxUtilizedMemoryPercentage = maxUtilizedMemoryPercentage;
        return this;
    }

    @ApiModelProperty(value="The maximum percentage of memory that was used by Impala for executing queries.")
    public BigDecimal getMaxUtilizedMemoryPercentage() {
        return this.maxUtilizedMemoryPercentage;
    }

    public void setMaxUtilizedMemoryPercentage(BigDecimal maxUtilizedMemoryPercentage) {
        this.maxUtilizedMemoryPercentage = maxUtilizedMemoryPercentage;
    }

    public ApiImpalaTenantUtilization allocatedAtMaxUtilized(BigDecimal allocatedAtMaxUtilized) {
        this.allocatedAtMaxUtilized = allocatedAtMaxUtilized;
        return this;
    }

    @ApiModelProperty(value="The amount of memory (in bytes) reserved by Impala at the time when it was using the maximum memory for executing queries.")
    public BigDecimal getAllocatedAtMaxUtilized() {
        return this.allocatedAtMaxUtilized;
    }

    public void setAllocatedAtMaxUtilized(BigDecimal allocatedAtMaxUtilized) {
        this.allocatedAtMaxUtilized = allocatedAtMaxUtilized;
    }

    public ApiImpalaTenantUtilization allocatedAtMaxUtilizedPercentage(BigDecimal allocatedAtMaxUtilizedPercentage) {
        this.allocatedAtMaxUtilizedPercentage = allocatedAtMaxUtilizedPercentage;
        return this;
    }

    @ApiModelProperty(value="The percentage of memory reserved by Impala at the time when it was using the maximum memory for executing queries.")
    public BigDecimal getAllocatedAtMaxUtilizedPercentage() {
        return this.allocatedAtMaxUtilizedPercentage;
    }

    public void setAllocatedAtMaxUtilizedPercentage(BigDecimal allocatedAtMaxUtilizedPercentage) {
        this.allocatedAtMaxUtilizedPercentage = allocatedAtMaxUtilizedPercentage;
    }

    public ApiImpalaTenantUtilization distributionUtilizedByImpalaDaemon(ApiImpalaUtilizationHistogram distributionUtilizedByImpalaDaemon) {
        this.distributionUtilizedByImpalaDaemon = distributionUtilizedByImpalaDaemon;
        return this;
    }

    @ApiModelProperty(value="Distribution of memory used per Impala daemon for executing queries at the time Impala used the maximum memory.")
    public ApiImpalaUtilizationHistogram getDistributionUtilizedByImpalaDaemon() {
        return this.distributionUtilizedByImpalaDaemon;
    }

    public void setDistributionUtilizedByImpalaDaemon(ApiImpalaUtilizationHistogram distributionUtilizedByImpalaDaemon) {
        this.distributionUtilizedByImpalaDaemon = distributionUtilizedByImpalaDaemon;
    }

    public ApiImpalaTenantUtilization distributionAllocatedByImpalaDaemon(ApiImpalaUtilizationHistogram distributionAllocatedByImpalaDaemon) {
        this.distributionAllocatedByImpalaDaemon = distributionAllocatedByImpalaDaemon;
        return this;
    }

    @ApiModelProperty(value="Distribution of memory reserved per Impala daemon for executing queries at the time Impala used the maximum memory.")
    public ApiImpalaUtilizationHistogram getDistributionAllocatedByImpalaDaemon() {
        return this.distributionAllocatedByImpalaDaemon;
    }

    public void setDistributionAllocatedByImpalaDaemon(ApiImpalaUtilizationHistogram distributionAllocatedByImpalaDaemon) {
        this.distributionAllocatedByImpalaDaemon = distributionAllocatedByImpalaDaemon;
    }

    public ApiImpalaTenantUtilization avgSpilledMemory(BigDecimal avgSpilledMemory) {
        this.avgSpilledMemory = avgSpilledMemory;
        return this;
    }

    @ApiModelProperty(value="Average spill per query.")
    public BigDecimal getAvgSpilledMemory() {
        return this.avgSpilledMemory;
    }

    public void setAvgSpilledMemory(BigDecimal avgSpilledMemory) {
        this.avgSpilledMemory = avgSpilledMemory;
    }

    public ApiImpalaTenantUtilization maxSpilledMemory(BigDecimal maxSpilledMemory) {
        this.maxSpilledMemory = maxSpilledMemory;
        return this;
    }

    @ApiModelProperty(value="Maximum spill per query.")
    public BigDecimal getMaxSpilledMemory() {
        return this.maxSpilledMemory;
    }

    public void setMaxSpilledMemory(BigDecimal maxSpilledMemory) {
        this.maxSpilledMemory = maxSpilledMemory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiImpalaTenantUtilization apiImpalaTenantUtilization = (ApiImpalaTenantUtilization)o;
        return Objects.equals(this.tenantName, apiImpalaTenantUtilization.tenantName) && Objects.equals(this.totalQueries, apiImpalaTenantUtilization.totalQueries) && Objects.equals(this.successfulQueries, apiImpalaTenantUtilization.successfulQueries) && Objects.equals(this.oomQueries, apiImpalaTenantUtilization.oomQueries) && Objects.equals(this.timeOutQueries, apiImpalaTenantUtilization.timeOutQueries) && Objects.equals(this.rejectedQueries, apiImpalaTenantUtilization.rejectedQueries) && Objects.equals(this.avgWaitTimeInQueue, apiImpalaTenantUtilization.avgWaitTimeInQueue) && Objects.equals(this.peakAllocationTimestampMS, apiImpalaTenantUtilization.peakAllocationTimestampMS) && Objects.equals(this.maxAllocatedMemory, apiImpalaTenantUtilization.maxAllocatedMemory) && Objects.equals(this.maxAllocatedMemoryPercentage, apiImpalaTenantUtilization.maxAllocatedMemoryPercentage) && Objects.equals(this.utilizedAtMaxAllocated, apiImpalaTenantUtilization.utilizedAtMaxAllocated) && Objects.equals(this.utilizedAtMaxAllocatedPercentage, apiImpalaTenantUtilization.utilizedAtMaxAllocatedPercentage) && Objects.equals(this.peakUsageTimestampMS, apiImpalaTenantUtilization.peakUsageTimestampMS) && Objects.equals(this.maxUtilizedMemory, apiImpalaTenantUtilization.maxUtilizedMemory) && Objects.equals(this.maxUtilizedMemoryPercentage, apiImpalaTenantUtilization.maxUtilizedMemoryPercentage) && Objects.equals(this.allocatedAtMaxUtilized, apiImpalaTenantUtilization.allocatedAtMaxUtilized) && Objects.equals(this.allocatedAtMaxUtilizedPercentage, apiImpalaTenantUtilization.allocatedAtMaxUtilizedPercentage) && Objects.equals(this.distributionUtilizedByImpalaDaemon, apiImpalaTenantUtilization.distributionUtilizedByImpalaDaemon) && Objects.equals(this.distributionAllocatedByImpalaDaemon, apiImpalaTenantUtilization.distributionAllocatedByImpalaDaemon) && Objects.equals(this.avgSpilledMemory, apiImpalaTenantUtilization.avgSpilledMemory) && Objects.equals(this.maxSpilledMemory, apiImpalaTenantUtilization.maxSpilledMemory);
    }

    public int hashCode() {
        return Objects.hash(this.tenantName, this.totalQueries, this.successfulQueries, this.oomQueries, this.timeOutQueries, this.rejectedQueries, this.avgWaitTimeInQueue, this.peakAllocationTimestampMS, this.maxAllocatedMemory, this.maxAllocatedMemoryPercentage, this.utilizedAtMaxAllocated, this.utilizedAtMaxAllocatedPercentage, this.peakUsageTimestampMS, this.maxUtilizedMemory, this.maxUtilizedMemoryPercentage, this.allocatedAtMaxUtilized, this.allocatedAtMaxUtilizedPercentage, this.distributionUtilizedByImpalaDaemon, this.distributionAllocatedByImpalaDaemon, this.avgSpilledMemory, this.maxSpilledMemory);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiImpalaTenantUtilization {\n");
        sb.append("    tenantName: ").append(this.toIndentedString(this.tenantName)).append("\n");
        sb.append("    totalQueries: ").append(this.toIndentedString(this.totalQueries)).append("\n");
        sb.append("    successfulQueries: ").append(this.toIndentedString(this.successfulQueries)).append("\n");
        sb.append("    oomQueries: ").append(this.toIndentedString(this.oomQueries)).append("\n");
        sb.append("    timeOutQueries: ").append(this.toIndentedString(this.timeOutQueries)).append("\n");
        sb.append("    rejectedQueries: ").append(this.toIndentedString(this.rejectedQueries)).append("\n");
        sb.append("    avgWaitTimeInQueue: ").append(this.toIndentedString(this.avgWaitTimeInQueue)).append("\n");
        sb.append("    peakAllocationTimestampMS: ").append(this.toIndentedString(this.peakAllocationTimestampMS)).append("\n");
        sb.append("    maxAllocatedMemory: ").append(this.toIndentedString(this.maxAllocatedMemory)).append("\n");
        sb.append("    maxAllocatedMemoryPercentage: ").append(this.toIndentedString(this.maxAllocatedMemoryPercentage)).append("\n");
        sb.append("    utilizedAtMaxAllocated: ").append(this.toIndentedString(this.utilizedAtMaxAllocated)).append("\n");
        sb.append("    utilizedAtMaxAllocatedPercentage: ").append(this.toIndentedString(this.utilizedAtMaxAllocatedPercentage)).append("\n");
        sb.append("    peakUsageTimestampMS: ").append(this.toIndentedString(this.peakUsageTimestampMS)).append("\n");
        sb.append("    maxUtilizedMemory: ").append(this.toIndentedString(this.maxUtilizedMemory)).append("\n");
        sb.append("    maxUtilizedMemoryPercentage: ").append(this.toIndentedString(this.maxUtilizedMemoryPercentage)).append("\n");
        sb.append("    allocatedAtMaxUtilized: ").append(this.toIndentedString(this.allocatedAtMaxUtilized)).append("\n");
        sb.append("    allocatedAtMaxUtilizedPercentage: ").append(this.toIndentedString(this.allocatedAtMaxUtilizedPercentage)).append("\n");
        sb.append("    distributionUtilizedByImpalaDaemon: ").append(this.toIndentedString(this.distributionUtilizedByImpalaDaemon)).append("\n");
        sb.append("    distributionAllocatedByImpalaDaemon: ").append(this.toIndentedString(this.distributionAllocatedByImpalaDaemon)).append("\n");
        sb.append("    avgSpilledMemory: ").append(this.toIndentedString(this.avgSpilledMemory)).append("\n");
        sb.append("    maxSpilledMemory: ").append(this.toIndentedString(this.maxSpilledMemory)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

