/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.ambari;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryConfig;
import org.apache.knox.gateway.topology.discovery.ambari.AmbariCluster;
import org.apache.knox.gateway.topology.discovery.ambari.RESTInvoker;

class AmbariClientCommon {
    static final String AMBARI_CLUSTERS_URI = "/api/v1/clusters";
    static final String AMBARI_HOSTROLES_URI = "/api/v1/clusters/%s/services?fields=components/host_components/HostRoles";
    static final String AMBARI_SERVICECONFIGS_URI = "/api/v1/clusters/%s/configurations/service_config_versions?is_current=true";
    private RESTInvoker restClient;

    AmbariClientCommon(GatewayConfig config, AliasService aliasService, KeystoreService keystoreService) {
        this(new RESTInvoker(config, aliasService, keystoreService));
    }

    AmbariClientCommon(RESTInvoker restInvoker) {
        this.restClient = restInvoker;
    }

    Map<String, Map<String, AmbariCluster.ServiceConfiguration>> getActiveServiceConfigurations(String clusterName, ServiceDiscoveryConfig config) {
        Map<String, Map<String, AmbariCluster.ServiceConfiguration>> activeConfigs = null;
        if (config != null) {
            activeConfigs = this.getActiveServiceConfigurations(config.getAddress(), clusterName, config.getUser(), config.getPasswordAlias());
        }
        return activeConfigs;
    }

    Map<String, Map<String, AmbariCluster.ServiceConfiguration>> getActiveServiceConfigurations(String discoveryAddress, String clusterName, String discoveryUser, String discoveryPwdAlias) {
        HashMap<String, Map<String, AmbariCluster.ServiceConfiguration>> serviceConfigurations = new HashMap<String, Map<String, AmbariCluster.ServiceConfiguration>>();
        String serviceConfigsURL = String.format(Locale.ROOT, "%s/api/v1/clusters/%s/configurations/service_config_versions?is_current=true", discoveryAddress, clusterName);
        JSONObject serviceConfigsJSON = this.restClient.invoke(serviceConfigsURL, discoveryUser, discoveryPwdAlias);
        if (serviceConfigsJSON != null) {
            JSONArray serviceConfigs = (JSONArray)serviceConfigsJSON.get((Object)"items");
            for (Object serviceConfig : serviceConfigs) {
                String serviceName = (String)((JSONObject)serviceConfig).get((Object)"service_name");
                JSONArray configurations = (JSONArray)((JSONObject)serviceConfig).get((Object)"configurations");
                for (Object configuration : configurations) {
                    String configType = (String)((JSONObject)configuration).get((Object)"type");
                    String configVersion = String.valueOf(((JSONObject)configuration).get((Object)"version"));
                    HashMap<String, String> configProps = new HashMap<String, String>();
                    JSONObject configProperties = (JSONObject)((JSONObject)configuration).get((Object)"properties");
                    for (Map.Entry entry : configProperties.entrySet()) {
                        configProps.put((String)entry.getKey(), String.valueOf(entry.getValue()));
                    }
                    if (!serviceConfigurations.containsKey(serviceName)) {
                        serviceConfigurations.put(serviceName, new HashMap());
                    }
                    ((Map)serviceConfigurations.get(serviceName)).put(configType, new AmbariCluster.ServiceConfiguration(configType, configVersion, configProps));
                }
            }
        }
        return serviceConfigurations;
    }
}

