/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.hbase.table;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.EmptyResponse;
import org.apache.knox.gateway.shell.KnoxSession;

public class TruncateTable {

    public static class Response
    extends EmptyResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String tableName;

        public Request(KnoxSession session, String tableName) {
            super(session);
            this.tableName = tableName;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    String schema;
                    URI uri = this.uri(new String[]{"/hbase", "/", tableName, "/schema"}).build();
                    HttpGet get = new HttpGet(uri);
                    get.setHeader("Accept", "text/xml");
                    try (CloseableHttpResponse getResponse = this.execute((HttpRequest)get);){
                        schema = EntityUtils.toString((HttpEntity)getResponse.getEntity());
                    }
                    HttpDelete delete = new HttpDelete(uri);
                    try (CloseableHttpResponse deleteResponse = this.execute((HttpRequest)delete);){
                        EntityUtils.consumeQuietly((HttpEntity)deleteResponse.getEntity());
                    }
                    HttpPut put = new HttpPut(uri);
                    StringEntity entity = new StringEntity(schema, ContentType.create((String)"text/xml", (Charset)StandardCharsets.UTF_8));
                    put.setEntity((HttpEntity)entity);
                    return new Response((HttpResponse)this.execute((HttpRequest)put));
                }
            };
        }
    }
}

